/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.bytes;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.bytes.ByteFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;

public class MultiValueByteFieldData
extends ByteFieldData {
    private static final int VALUE_CACHE_SIZE = 10;
    private ThreadLocal<ThreadLocals.CleanableValue<double[][]>> doublesValuesCache = new ThreadLocal<ThreadLocals.CleanableValue<double[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[][]> initialValue() {
            double[][] value = new double[10][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new double[i];
            }
            return new ThreadLocals.CleanableValue<double[][]>(value);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<byte[][]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<byte[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<byte[][]> initialValue() {
            byte[][] value = new byte[10][];
            for (int i = 0; i < value.length; ++i) {
                value[i] = new byte[i];
            }
            return new ThreadLocals.CleanableValue<byte[][]>(value);
        }
    };
    private final int[][] ordinals;

    public MultiValueByteFieldData(String fieldName, int[][] ordinals, byte[] values) {
        super(fieldName, values);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size = super.computeSizeInBytes();
        size += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc.onValue(docId, Byte.toString(this.values[loc]));
        }
        if (!found) {
            proc.onMissing(docId);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.DoubleValueInDocProc proc) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc.onValue(docId, this.values[loc]);
        }
        if (!found) {
            proc.onMissing(docId);
        }
    }

    @Override
    public void forEachValueInDoc(int docId, ByteFieldData.ValueInDocProc proc) {
        boolean found = false;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            found = true;
            proc.onValue(docId, this.values[loc]);
        }
        if (!found) {
            proc.onMissing(docId);
        }
    }

    @Override
    public double[] doubleValues(int docId) {
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length;
        }
        if (length == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = length < 10 ? this.doublesValuesCache.get().get()[length] : new double[length];
        int i = 0;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            doubles[i++] = this.values[loc];
        }
        return doubles;
    }

    @Override
    public byte value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.values[loc];
        }
        return 0;
    }

    @Override
    public byte[] values(int docId) {
        int length = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            ++length;
        }
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = length < 10 ? this.valuesCache.get().get()[length] : new byte[length];
        int i = 0;
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            bytes[i++] = this.values[loc];
        }
        return bytes;
    }
}

