/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.longs;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.doubles.DoubleFieldData;
import org.elasticsearch.index.field.data.longs.LongFieldData;

public class SingleValueLongFieldData
extends LongFieldData {
    private ThreadLocal<ThreadLocals.CleanableValue<double[]>> doublesValuesCache = new ThreadLocal<ThreadLocals.CleanableValue<double[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<double[]> initialValue() {
            return new ThreadLocals.CleanableValue<double[]>(new double[1]);
        }
    };
    private ThreadLocal<ThreadLocals.CleanableValue<MutableDateTime[]>> datesValuesCache = new ThreadLocal<ThreadLocals.CleanableValue<MutableDateTime[]>>(){

        @Override
        protected ThreadLocals.CleanableValue<MutableDateTime[]> initialValue() {
            MutableDateTime[] date = new MutableDateTime[]{new MutableDateTime(DateTimeZone.UTC)};
            return new ThreadLocals.CleanableValue<MutableDateTime[]>(date);
        }
    };
    private ThreadLocal<long[]> valuesCache = new ThreadLocal<long[]>(){

        @Override
        protected long[] initialValue() {
            return new long[1];
        }
    };
    private final int[] ordinals;

    public SingleValueLongFieldData(String fieldName, int[] ordinals, long[] values) {
        super(fieldName, values);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        return super.computeSizeInBytes() + (long)(4 * this.ordinals.length) + (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    @Override
    public boolean multiValued() {
        return false;
    }

    @Override
    public boolean hasValue(int docId) {
        return this.ordinals[docId] != 0;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc.onMissing(docId);
            return;
        }
        proc.onValue(docId, Long.toString(this.values[loc]));
    }

    @Override
    public void forEachValueInDoc(int docId, NumericFieldData.DoubleValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc.onMissing(docId);
            return;
        }
        proc.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, LongFieldData.ValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            proc.onMissing(docId);
            return;
        }
        proc.onValue(docId, this.values[loc]);
    }

    @Override
    public void forEachValueInDoc(int docId, LongFieldData.DateValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return;
        }
        MutableDateTime dateTime = (MutableDateTime)((ThreadLocals.CleanableValue)this.dateTimeCache.get()).get();
        dateTime.setMillis(this.values[loc]);
        proc.onValue(docId, dateTime);
    }

    @Override
    public void forEachValueInDoc(int docId, MutableDateTime dateTime, LongFieldData.DateValueInDocProc proc) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return;
        }
        dateTime.setMillis(this.values[loc]);
        proc.onValue(docId, dateTime);
    }

    @Override
    public MutableDateTime[] dates(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return EMPTY_DATETIME_ARRAY;
        }
        MutableDateTime[] ret = this.datesValuesCache.get().get();
        ret[0].setMillis(this.values[loc]);
        return ret;
    }

    @Override
    public double[] doubleValues(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return DoubleFieldData.EMPTY_DOUBLE_ARRAY;
        }
        double[] ret = this.doublesValuesCache.get().get();
        ret[0] = this.values[loc];
        return ret;
    }

    @Override
    public long value(int docId) {
        return this.values[this.ordinals[docId]];
    }

    @Override
    public long[] values(int docId) {
        int loc = this.ordinals[docId];
        if (loc == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] ret = this.valuesCache.get();
        ret[0] = this.values[loc];
        return ret;
    }
}

