/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.strings;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.strings.MultiValueStringFieldData;
import org.elasticsearch.index.field.data.strings.SingleValueStringFieldData;
import org.elasticsearch.index.field.data.strings.StringDocFieldData;
import org.elasticsearch.index.field.data.support.FieldDataLoader;

public abstract class StringFieldData
extends FieldData<StringDocFieldData> {
    protected final String[] values;

    protected StringFieldData(String fieldName, String[] values) {
        super(fieldName);
        this.values = values;
    }

    @Override
    protected long computeSizeInBytes() {
        long size = RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (String value : this.values) {
            if (value == null) continue;
            size += (long)(8 + (value.length() * 2 + 12));
        }
        return size;
    }

    public abstract String value(int var1);

    public abstract String[] values(int var1);

    @Override
    public StringDocFieldData docFieldData(int docId) {
        return (StringDocFieldData)super.docFieldData(docId);
    }

    @Override
    public String stringValue(int docId) {
        return this.value(docId);
    }

    @Override
    protected StringDocFieldData createFieldData() {
        return new StringDocFieldData(this);
    }

    @Override
    public FieldDataType type() {
        return FieldDataType.DefaultTypes.STRING;
    }

    @Override
    public void forEachValue(FieldData.StringValueProc proc) {
        for (int i = 1; i < this.values.length; ++i) {
            proc.onValue(this.values[i]);
        }
    }

    public static StringFieldData load(IndexReader reader, String field) throws IOException {
        return FieldDataLoader.load(reader, field, new StringTypeLoader());
    }

    static class StringTypeLoader
    extends FieldDataLoader.FreqsTypeLoader<StringFieldData> {
        private final ArrayList<String> terms = new ArrayList();

        StringTypeLoader() {
            this.terms.add(null);
        }

        @Override
        public void collectTerm(String term) {
            this.terms.add(term);
        }

        @Override
        public StringFieldData buildSingleValue(String field, int[] ordinals) {
            return new SingleValueStringFieldData(field, ordinals, this.terms.toArray(new String[this.terms.size()]));
        }

        @Override
        public StringFieldData buildMultiValue(String field, int[][] ordinals) {
            return new MultiValueStringFieldData(field, ordinals, this.terms.toArray(new String[this.terms.size()]));
        }
    }
}

