/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.strings;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.strings.MultiValueStringFieldData;
import org.elasticsearch.index.field.data.strings.SingleValueStringFieldData;

public class StringOrdValFieldDataComparator
extends FieldComparator {
    private final FieldDataCache fieldDataCache;
    private final int[] ords;
    private final String[] values;
    private final int[] readerGen;
    private int currentReaderGen = -1;
    private String[] lookup;
    private int[] order;
    private final String field;
    private int bottomSlot = -1;
    private int bottomOrd;
    private String bottomValue;
    private final boolean reversed;
    private final int sortPos;

    public StringOrdValFieldDataComparator(int numHits, String field, int sortPos, boolean reversed, FieldDataCache fieldDataCache) {
        this.fieldDataCache = fieldDataCache;
        this.ords = new int[numHits];
        this.values = new String[numHits];
        this.readerGen = new int[numHits];
        this.sortPos = sortPos;
        this.reversed = reversed;
        this.field = field;
    }

    public int compare(int slot1, int slot2) {
        int cmp;
        if (this.readerGen[slot1] == this.readerGen[slot2] && (cmp = this.ords[slot1] - this.ords[slot2]) != 0) {
            return cmp;
        }
        String val1 = this.values[slot1];
        String val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return val1.compareTo(val2);
    }

    public int compareBottom(int doc) {
        assert (this.bottomSlot != -1);
        int order = this.order[doc];
        int cmp = this.bottomOrd - order;
        if (cmp != 0) {
            return cmp;
        }
        String val2 = this.lookup[order];
        if (this.bottomValue == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return this.bottomValue.compareTo(val2);
    }

    private void convert(int slot) {
        this.readerGen[slot] = this.currentReaderGen;
        int index = 0;
        String value = this.values[slot];
        if (value == null) {
            this.ords[slot] = 0;
            return;
        }
        if (this.sortPos == 0 && this.bottomSlot != -1 && this.bottomSlot != slot) {
            assert (this.bottomOrd < this.lookup.length);
            index = this.reversed ? StringOrdValFieldDataComparator.binarySearch((String[])this.lookup, (String)value, (int)this.bottomOrd, (int)(this.lookup.length - 1)) : StringOrdValFieldDataComparator.binarySearch((String[])this.lookup, (String)value, (int)0, (int)this.bottomOrd);
        } else {
            index = StringOrdValFieldDataComparator.binarySearch((String[])this.lookup, (String)value);
        }
        if (index < 0) {
            index = -index - 2;
        }
        this.ords[slot] = index;
    }

    public void copy(int slot, int doc) {
        int ord;
        this.ords[slot] = ord = this.order[doc];
        assert (ord >= 0);
        this.values[slot] = this.lookup[ord];
        this.readerGen[slot] = this.currentReaderGen;
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        FieldData cleanFieldData = this.fieldDataCache.cache(FieldDataType.DefaultTypes.STRING, reader, this.field);
        if (cleanFieldData instanceof MultiValueStringFieldData) {
            throw new IOException("Can't sort on string types with more than one value per doc, or more than one token per field");
        }
        SingleValueStringFieldData fieldData = (SingleValueStringFieldData)cleanFieldData;
        ++this.currentReaderGen;
        this.order = fieldData.ordinals();
        this.lookup = fieldData.values();
        assert (this.lookup.length > 0);
        if (this.bottomSlot != -1) {
            this.convert(this.bottomSlot);
            this.bottomOrd = this.ords[this.bottomSlot];
        }
    }

    public void setBottom(int bottom) {
        this.bottomSlot = bottom;
        if (this.readerGen[bottom] != this.currentReaderGen) {
            this.convert(this.bottomSlot);
        }
        this.bottomOrd = this.ords[bottom];
        assert (this.bottomOrd >= 0);
        assert (this.bottomOrd < this.lookup.length);
        this.bottomValue = this.values[bottom];
    }

    public Comparable value(int slot) {
        return this.values[slot];
    }

    public String[] getValues() {
        return this.values;
    }

    public int getBottomSlot() {
        return this.bottomSlot;
    }

    public String getField() {
        return this.field;
    }
}

