/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.function.sort;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.SearchScript;

public class StringFieldsFunctionDataComparator
extends FieldComparator {
    private final SearchScript script;
    private String[] values;
    private String bottom;

    public static FieldComparatorSource comparatorSource(SearchScript script) {
        return new InnerSource(script);
    }

    public StringFieldsFunctionDataComparator(int numHits, SearchScript script) {
        this.script = script;
        this.values = new String[numHits];
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.script.setNextReader(reader);
    }

    public void setScorer(Scorer scorer) {
        this.script.setScorer(scorer);
    }

    public int compare(int slot1, int slot2) {
        String val1 = this.values[slot1];
        String val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return val1.compareTo(val2);
    }

    public int compareBottom(int doc) {
        this.script.setNextDocId(doc);
        String val2 = this.script.run().toString();
        if (this.bottom == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return this.bottom.compareTo(val2);
    }

    public void copy(int slot, int doc) {
        this.script.setNextDocId(doc);
        this.values[slot] = this.script.run().toString();
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return this.values[slot];
    }

    private static class InnerSource
    extends FieldComparatorSource {
        private final SearchScript script;

        private InnerSource(SearchScript script) {
            this.script = script;
        }

        public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new StringFieldsFunctionDataComparator(numHits, this.script);
        }
    }
}

