/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TermRangeQuery;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public abstract class AbstractFieldMapper<T>
implements FieldMapper<T>,
XContentMapper {
    protected final FieldMapper.Names names;
    protected final Field.Index index;
    protected final Field.Store store;
    protected final Field.TermVector termVector;
    protected float boost;
    protected boolean omitNorms;
    protected boolean omitTermFreqAndPositions;
    protected final NamedAnalyzer indexAnalyzer;
    protected final NamedAnalyzer searchAnalyzer;

    protected AbstractFieldMapper(FieldMapper.Names names, Field.Index index, Field.Store store, Field.TermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer) {
        this.names = names;
        this.index = index;
        this.store = store;
        this.termVector = termVector;
        this.boost = boost;
        this.omitNorms = omitNorms;
        this.omitTermFreqAndPositions = omitTermFreqAndPositions;
        this.indexAnalyzer = indexAnalyzer == null && !index.isAnalyzed() ? Lucene.KEYWORD_ANALYZER : indexAnalyzer;
        this.searchAnalyzer = searchAnalyzer == null && !index.isAnalyzed() ? Lucene.KEYWORD_ANALYZER : searchAnalyzer;
    }

    @Override
    public String name() {
        return this.names.name();
    }

    @Override
    public FieldMapper.Names names() {
        return this.names;
    }

    @Override
    public Field.Index index() {
        return this.index;
    }

    @Override
    public Field.Store store() {
        return this.store;
    }

    @Override
    public boolean stored() {
        return this.store == Field.Store.YES;
    }

    @Override
    public boolean indexed() {
        return this.index != Field.Index.NO;
    }

    @Override
    public boolean analyzed() {
        return this.index == Field.Index.ANALYZED;
    }

    @Override
    public Field.TermVector termVector() {
        return this.termVector;
    }

    @Override
    public float boost() {
        return this.boost;
    }

    @Override
    public boolean omitNorms() {
        return this.omitNorms;
    }

    @Override
    public boolean omitTermFreqAndPositions() {
        return this.omitTermFreqAndPositions;
    }

    @Override
    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        try {
            Fieldable field = this.parseCreateField(context);
            if (field == null) {
                return;
            }
            field.setOmitNorms(this.omitNorms);
            field.setOmitTermFreqAndPositions(this.omitTermFreqAndPositions);
            field.setBoost(this.boost);
            if (context.listener().beforeFieldAdded(this, field, context)) {
                context.doc().add(field);
            }
        }
        catch (Exception e) {
            throw new MapperParsingException("Failed to parse [" + this.names.fullName() + "]", e);
        }
    }

    protected abstract Fieldable parseCreateField(ParseContext var1) throws IOException;

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        fieldMapperListener.fieldMapper(this);
    }

    @Override
    public Object valueForSearch(Fieldable field) {
        return this.valueAsString(field);
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    @Override
    public Query queryStringTermQuery(Term term) {
        return null;
    }

    @Override
    public boolean useFieldQueryWithQueryString() {
        return false;
    }

    @Override
    public Query fieldQuery(String value) {
        return new TermQuery(new Term(this.names.indexName(), this.indexedValue(value)));
    }

    @Override
    public Filter fieldFilter(String value) {
        return new TermFilter(new Term(this.names.indexName(), this.indexedValue(value)));
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return new TermRangeQuery(this.names.indexName(), lowerTerm == null ? null : this.indexedValue(lowerTerm), upperTerm == null ? null : this.indexedValue(upperTerm), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return new TermRangeFilter(this.names.indexName(), lowerTerm == null ? null : this.indexedValue(lowerTerm), upperTerm == null ? null : this.indexedValue(upperTerm), includeLower, includeUpper);
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        if (!this.getClass().equals(mergeWith.getClass())) {
            String mergedType = mergeWith.getClass().getSimpleName();
            if (mergeWith instanceof AbstractFieldMapper) {
                mergedType = ((AbstractFieldMapper)mergeWith).contentType();
            }
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] of different type, current_type [" + this.contentType() + "], merged_type [" + mergedType + "]");
            return;
        }
        AbstractFieldMapper fieldMergeWith = (AbstractFieldMapper)mergeWith;
        if (!this.index.equals((Object)fieldMergeWith.index)) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index values");
        }
        if (!this.store.equals((Object)fieldMergeWith.store)) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different store values");
        }
        if (!this.termVector.equals((Object)fieldMergeWith.termVector)) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different term_vector values");
        }
        if (this.indexAnalyzer == null) {
            if (fieldMergeWith.indexAnalyzer != null) {
                mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_analyzer");
            }
        } else if (fieldMergeWith.indexAnalyzer == null) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_analyzer");
        } else if (!this.indexAnalyzer.name().equals(fieldMergeWith.indexAnalyzer.name())) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different index_analyzer");
        }
        if (this.searchAnalyzer == null) {
            if (fieldMergeWith.searchAnalyzer != null) {
                mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different search_analyzer");
            }
        } else if (fieldMergeWith.searchAnalyzer == null) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different search_analyzer");
        } else if (!this.searchAnalyzer.name().equals(fieldMergeWith.searchAnalyzer.name())) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different search_analyzer");
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.boost = fieldMergeWith.boost;
            this.omitNorms = fieldMergeWith.omitNorms;
            this.omitTermFreqAndPositions = fieldMergeWith.omitTermFreqAndPositions;
        }
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.STRING;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.names.name());
        this.doXContentBody(builder);
        builder.endObject();
        return builder;
    }

    protected void doXContentBody(XContentBuilder builder) throws IOException {
        builder.field("type", this.contentType());
        if (!this.names.name().equals(this.names.indexNameClean())) {
            builder.field("index_name", this.names.indexNameClean());
        }
        if (this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.indexAnalyzer != null && this.searchAnalyzer != null && this.indexAnalyzer.name().equals(this.searchAnalyzer.name()) && !this.indexAnalyzer.name().startsWith("_")) {
            builder.field("analyzer", this.indexAnalyzer.name());
        } else {
            if (this.indexAnalyzer != null && !this.indexAnalyzer.name().startsWith("_")) {
                builder.field("index_analyzer", this.indexAnalyzer.name());
            }
            if (this.searchAnalyzer != null && !this.searchAnalyzer.name().startsWith("_")) {
                builder.field("search_analyzer", this.searchAnalyzer.name());
            }
        }
    }

    protected abstract String contentType();

    public static abstract class Builder<T extends Builder, Y extends AbstractFieldMapper>
    extends XContentMapper.Builder<T, Y> {
        protected Field.Index index = Defaults.INDEX;
        protected Field.Store store = Defaults.STORE;
        protected Field.TermVector termVector = Defaults.TERM_VECTOR;
        protected float boost = 1.0f;
        protected boolean omitNorms = false;
        protected boolean omitTermFreqAndPositions = false;
        protected String indexName;
        protected NamedAnalyzer indexAnalyzer;
        protected NamedAnalyzer searchAnalyzer;
        protected Boolean includeInAll;

        protected Builder(String name) {
            super(name);
        }

        protected T index(Field.Index index) {
            this.index = index;
            return (T)((Builder)this.builder);
        }

        protected T store(Field.Store store) {
            this.store = store;
            return (T)((Builder)this.builder);
        }

        protected T termVector(Field.TermVector termVector) {
            this.termVector = termVector;
            return (T)((Builder)this.builder);
        }

        protected T boost(float boost) {
            this.boost = boost;
            return (T)((Builder)this.builder);
        }

        protected T omitNorms(boolean omitNorms) {
            this.omitNorms = omitNorms;
            return (T)((Builder)this.builder);
        }

        protected T omitTermFreqAndPositions(boolean omitTermFreqAndPositions) {
            this.omitTermFreqAndPositions = omitTermFreqAndPositions;
            return (T)((Builder)this.builder);
        }

        protected T indexName(String indexName) {
            this.indexName = indexName;
            return (T)((Builder)this.builder);
        }

        protected T indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.indexAnalyzer = indexAnalyzer;
            if (this.searchAnalyzer == null) {
                this.searchAnalyzer = indexAnalyzer;
            }
            return (T)((Builder)this.builder);
        }

        protected T searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.searchAnalyzer = searchAnalyzer;
            return (T)((Builder)this.builder);
        }

        protected T includeInAll(Boolean includeInAll) {
            this.includeInAll = includeInAll;
            return (T)((Builder)this.builder);
        }

        protected FieldMapper.Names buildNames(XContentMapper.BuilderContext context) {
            return new FieldMapper.Names(this.name, this.buildIndexName(context), this.indexName == null ? this.name : this.indexName, this.buildFullName(context));
        }

        protected String buildIndexName(XContentMapper.BuilderContext context) {
            String actualIndexName = this.indexName == null ? this.name : this.indexName;
            return context.path().pathAsText(actualIndexName);
        }

        protected String buildFullName(XContentMapper.BuilderContext context) {
            return context.path().fullPathAsText(this.name);
        }
    }

    public static abstract class OpenBuilder<T extends Builder, Y extends AbstractFieldMapper>
    extends Builder<T, Y> {
        protected OpenBuilder(String name) {
            super(name);
        }

        @Override
        public T index(Field.Index index) {
            return super.index(index);
        }

        @Override
        public T store(Field.Store store) {
            return super.store(store);
        }

        @Override
        public T termVector(Field.TermVector termVector) {
            return super.termVector(termVector);
        }

        @Override
        public T boost(float boost) {
            return super.boost(boost);
        }

        @Override
        public T omitNorms(boolean omitNorms) {
            return super.omitNorms(omitNorms);
        }

        @Override
        public T omitTermFreqAndPositions(boolean omitTermFreqAndPositions) {
            return super.omitTermFreqAndPositions(omitTermFreqAndPositions);
        }

        @Override
        public T indexName(String indexName) {
            return super.indexName(indexName);
        }

        @Override
        public T indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            return super.indexAnalyzer(indexAnalyzer);
        }

        @Override
        public T searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            return super.searchAnalyzer(searchAnalyzer);
        }
    }

    public static class Defaults {
        public static final Field.Index INDEX = Field.Index.ANALYZED;
        public static final Field.Store STORE = Field.Store.NO;
        public static final Field.TermVector TERM_VECTOR = Field.TermVector.NO;
        public static final float BOOST = 1.0f;
        public static final boolean OMIT_NORMS = false;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = false;
    }
}

