/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class IdFieldMapper
extends AbstractFieldMapper<String>
implements org.elasticsearch.index.mapper.IdFieldMapper {
    public static final String CONTENT_TYPE = "_id";

    protected IdFieldMapper() {
        this(CONTENT_TYPE, CONTENT_TYPE);
    }

    protected IdFieldMapper(String name, String indexName) {
        this(name, indexName, Defaults.STORE, Defaults.TERM_VECTOR, 1.0f, true, true);
    }

    protected IdFieldMapper(String name, String indexName, Field.Store store, Field.TermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        super(new FieldMapper.Names(name, indexName, indexName, name), Defaults.INDEX, store, termVector, boost, omitNorms, omitTermFreqAndPositions, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
    }

    @Override
    public String value(Document document) {
        Fieldable field = document.getFieldable(this.names.indexName());
        return field == null ? null : this.value(field);
    }

    @Override
    public String value(Fieldable field) {
        return field.stringValue();
    }

    @Override
    public String valueFromString(String value) {
        return value;
    }

    @Override
    public String valueAsString(Fieldable field) {
        return this.value(field);
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    protected Field parseCreateField(ParseContext context) throws IOException {
        if (context.parsedIdState() == ParseContext.ParsedIdState.NO) {
            String id = context.parser().text();
            if (context.id() != null && !context.id().equals(id)) {
                throw new MapperParsingException("Provided id [" + context.id() + "] does not match the content one [" + id + "]");
            }
            context.id(id);
            context.parsedId(ParseContext.ParsedIdState.PARSED);
            return new Field(this.names.indexName(), context.id(), this.store, this.index);
        }
        if (context.parsedIdState() == ParseContext.ParsedIdState.EXTERNAL) {
            if (context.id() == null) {
                throw new MapperParsingException("No id mapping with [" + this.names.name() + "] found in the content, and not explicitly set");
            }
            return new Field(this.names.indexName(), context.id(), this.store, this.index);
        }
        throw new MapperParsingException("Illegal parsed id state");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.store == Defaults.STORE) {
            return builder;
        }
        builder.startObject(CONTENT_TYPE);
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, IdFieldMapper> {
        public Builder() {
            super(IdFieldMapper.CONTENT_TYPE);
            this.indexName = IdFieldMapper.CONTENT_TYPE;
            this.store = Defaults.STORE;
            this.index = Defaults.INDEX;
            this.omitNorms = true;
            this.omitTermFreqAndPositions = true;
        }

        @Override
        public IdFieldMapper build(XContentMapper.BuilderContext context) {
            return new IdFieldMapper(this.name, this.indexName, this.store, this.termVector, this.boost, this.omitNorms, this.omitTermFreqAndPositions);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_id";
        public static final String INDEX_NAME = "_id";
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final Field.Store STORE = Field.Store.NO;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
    }
}

