/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericLongAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.NumberFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapperBuilders;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class LongFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "long";
    private Long nullValue;
    private String nullValueAsString;

    protected LongFieldMapper(FieldMapper.Names names, int precisionStep, Field.Index index, Field.Store store, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, Long nullValue) {
        super(names, precisionStep, index, store, boost, omitNorms, omitTermFreqAndPositions, new NamedAnalyzer("_long/" + precisionStep, new NumericLongAnalyzer(precisionStep)), new NamedAnalyzer("_long/max", new NumericLongAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return null;
        }
        return Numbers.bytesToLong(value);
    }

    @Override
    public Long valueFromString(String value) {
        return Long.valueOf(value);
    }

    @Override
    public String indexedValue(String value) {
        return NumericUtils.longToPrefixCoded((long)Long.parseLong(value));
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(Long.parseLong(lowerTerm))), (Long)(upperTerm == null ? null : Long.valueOf(Long.parseLong(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(Long.parseLong(lowerTerm))), (Long)(upperTerm == null ? null : Long.valueOf(Long.parseLong(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFieldDataFilter.newLongRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Long.valueOf(Long.parseLong(lowerTerm)), upperTerm == null ? null : Long.valueOf(Long.parseLong(upperTerm)), includeLower, includeUpper);
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        long value;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.nullValue == null) {
                    return null;
                }
                value = this.nullValue;
            } else {
                value = ((Number)externalValue).longValue();
            }
            if (context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), Long.toString(value), this.boost);
            }
        } else if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return null;
            }
            value = this.nullValue;
            if (this.nullValueAsString != null && context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), this.nullValueAsString, this.boost);
            }
        } else {
            value = context.parser().longValue();
            if (context.includeInAll(this.includeInAll)) {
                context.allEntries().addText(this.names.fullName(), context.parser().text(), this.boost);
            }
        }
        return new CustomLongNumericField((NumberFieldMapper)this, value);
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.LONG;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((LongFieldMapper)mergeWith).nullValue;
            this.nullValueAsString = ((LongFieldMapper)mergeWith).nullValueAsString;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (!this.omitTermFreqAndPositions) {
            builder.field("omit_term_freq_and_positions", this.omitTermFreqAndPositions);
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    public static class CustomLongNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final long number;
        private final NumberFieldMapper mapper;

        public CustomLongNumericField(NumberFieldMapper mapper, long number) {
            super(mapper, mapper.stored() ? Numbers.longToBytes(number) : null);
            this.mapper = mapper;
            this.number = number;
        }

        public TokenStream tokenStreamValue() {
            if (this.isIndexed) {
                return this.mapper.popCachedStream().setLongValue(this.number);
            }
            return null;
        }
    }

    public static class TypeParser
    implements XContentMapper.TypeParser {
        @Override
        public XContentMapper.Builder parse(String name, Map<String, Object> node, XContentMapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = XContentMapperBuilders.longField(name);
            XContentTypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeLongValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, LongFieldMapper> {
        protected Long nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder nullValue(long nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public LongFieldMapper build(XContentMapper.BuilderContext context) {
            LongFieldMapper fieldMapper = new LongFieldMapper(this.buildNames(context), this.precisionStep, this.index, this.store, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final Long NULL_VALUE = null;
    }
}

