/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class TypeFieldMapper
extends AbstractFieldMapper<String>
implements org.elasticsearch.index.mapper.TypeFieldMapper {
    public static final String CONTENT_TYPE = "_type";

    protected TypeFieldMapper() {
        this(CONTENT_TYPE, CONTENT_TYPE);
    }

    protected TypeFieldMapper(String name, String indexName) {
        this(name, indexName, Defaults.STORE, Defaults.TERM_VECTOR, 1.0f, true, true);
    }

    public TypeFieldMapper(String name, String indexName, Field.Store store, Field.TermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions) {
        super(new FieldMapper.Names(name, indexName, indexName, name), Defaults.INDEX, store, termVector, boost, omitNorms, omitTermFreqAndPositions, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
    }

    @Override
    public String value(Document document) {
        Fieldable field = document.getFieldable(this.names.indexName());
        return field == null ? null : this.value(field);
    }

    @Override
    public String value(Fieldable field) {
        return field.stringValue();
    }

    @Override
    public String valueFromString(String value) {
        return value;
    }

    @Override
    public String valueAsString(Fieldable field) {
        return this.value(field);
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    @Override
    public Term term(String value) {
        return new Term(this.names.indexName(), value);
    }

    protected Field parseCreateField(ParseContext context) throws IOException {
        return new Field(this.names.indexName(), context.type(), this.store, this.index);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.store == Defaults.STORE) {
            return builder;
        }
        builder.startObject(CONTENT_TYPE);
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, TypeFieldMapper> {
        public Builder() {
            super(TypeFieldMapper.CONTENT_TYPE);
            this.indexName = TypeFieldMapper.CONTENT_TYPE;
            this.index = Defaults.INDEX;
            this.store = Defaults.STORE;
            this.omitNorms = true;
            this.omitTermFreqAndPositions = true;
        }

        @Override
        public TypeFieldMapper build(XContentMapper.BuilderContext context) {
            return new TypeFieldMapper(this.name, this.indexName, this.store, this.termVector, this.boost, this.omitNorms, this.omitTermFreqAndPositions);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_type";
        public static final String INDEX_NAME = "_type";
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final Field.Store STORE = Field.Store.NO;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
    }
}

