/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.xcontent.AllFieldMapper;
import org.elasticsearch.index.mapper.xcontent.AnalyzerMapper;
import org.elasticsearch.index.mapper.xcontent.BinaryFieldMapper;
import org.elasticsearch.index.mapper.xcontent.BooleanFieldMapper;
import org.elasticsearch.index.mapper.xcontent.BoostFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ByteFieldMapper;
import org.elasticsearch.index.mapper.xcontent.DateFieldMapper;
import org.elasticsearch.index.mapper.xcontent.DoubleFieldMapper;
import org.elasticsearch.index.mapper.xcontent.FloatFieldMapper;
import org.elasticsearch.index.mapper.xcontent.IdFieldMapper;
import org.elasticsearch.index.mapper.xcontent.IndexFieldMapper;
import org.elasticsearch.index.mapper.xcontent.IntegerFieldMapper;
import org.elasticsearch.index.mapper.xcontent.LongFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MultiFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ObjectMapper;
import org.elasticsearch.index.mapper.xcontent.ParentFieldMapper;
import org.elasticsearch.index.mapper.xcontent.RootObjectMapper;
import org.elasticsearch.index.mapper.xcontent.RoutingFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ShortFieldMapper;
import org.elasticsearch.index.mapper.xcontent.SourceFieldMapper;
import org.elasticsearch.index.mapper.xcontent.StringFieldMapper;
import org.elasticsearch.index.mapper.xcontent.TypeFieldMapper;
import org.elasticsearch.index.mapper.xcontent.UidFieldMapper;
import org.elasticsearch.index.mapper.xcontent.XContentDocumentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapperBuilders;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ip.IpFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class XContentDocumentMapperParser
extends AbstractIndexComponent
implements DocumentMapperParser {
    final AnalysisService analysisService;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Object typeParsersMutex = new Object();
    private volatile ImmutableMap<String, XContentMapper.TypeParser> typeParsers;

    public XContentDocumentMapperParser(Index index, AnalysisService analysisService) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS, analysisService);
    }

    public XContentDocumentMapperParser(Index index, @IndexSettings Settings indexSettings, AnalysisService analysisService) {
        super(index, indexSettings);
        this.analysisService = analysisService;
        this.typeParsers = new MapBuilder<String, ByteFieldMapper.TypeParser>().put("byte", new ByteFieldMapper.TypeParser()).put("short", (ByteFieldMapper.TypeParser)((Object)new ShortFieldMapper.TypeParser())).put("integer", (ByteFieldMapper.TypeParser)((Object)new IntegerFieldMapper.TypeParser())).put("long", (ByteFieldMapper.TypeParser)((Object)new LongFieldMapper.TypeParser())).put("float", (ByteFieldMapper.TypeParser)((Object)new FloatFieldMapper.TypeParser())).put("double", (ByteFieldMapper.TypeParser)((Object)new DoubleFieldMapper.TypeParser())).put("boolean", (ByteFieldMapper.TypeParser)((Object)new BooleanFieldMapper.TypeParser())).put("binary", (ByteFieldMapper.TypeParser)((Object)new BinaryFieldMapper.TypeParser())).put("date", (ByteFieldMapper.TypeParser)((Object)new DateFieldMapper.TypeParser())).put("ip", (ByteFieldMapper.TypeParser)((Object)new IpFieldMapper.TypeParser())).put("string", (ByteFieldMapper.TypeParser)((Object)new StringFieldMapper.TypeParser())).put("object", (ByteFieldMapper.TypeParser)((Object)new ObjectMapper.TypeParser())).put("multi_field", (ByteFieldMapper.TypeParser)((Object)new MultiFieldMapper.TypeParser())).put("geo_point", (ByteFieldMapper.TypeParser)((Object)new GeoPointFieldMapper.TypeParser())).immutableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTypeParser(String type, XContentMapper.TypeParser typeParser) {
        Object object = this.typeParsersMutex;
        synchronized (object) {
            this.typeParsers = new MapBuilder<String, XContentMapper.TypeParser>().putAll(this.typeParsers).put(type, typeParser).immutableMap();
        }
    }

    public XContentMapper.TypeParser.ParserContext parserContext() {
        return new XContentMapper.TypeParser.ParserContext(this.analysisService, this.typeParsers);
    }

    @Override
    public XContentDocumentMapper parse(String source) throws MapperParsingException {
        return this.parse(null, source);
    }

    @Override
    public XContentDocumentMapper parse(@Nullable String type, String source) throws MapperParsingException {
        return this.parse(type, source, null);
    }

    @Override
    public XContentDocumentMapper parse(@Nullable String type, String source, String defaultSource) throws MapperParsingException {
        Tuple<String, Map<String, Object>> t;
        HashMap<String, Object> mapping = null;
        if (source != null) {
            t = this.extractMapping(type, source);
            type = t.v1();
            mapping = t.v2();
        }
        if (mapping == null) {
            mapping = Maps.newHashMap();
        }
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        if (defaultSource != null && (t = this.extractMapping("_default_", defaultSource)).v2() != null) {
            XContentHelper.mergeDefaults(mapping, t.v2());
        }
        XContentMapper.TypeParser.ParserContext parserContext = new XContentMapper.TypeParser.ParserContext(this.analysisService, this.typeParsers);
        XContentDocumentMapper.Builder docBuilder = XContentMapperBuilders.doc(this.index.name(), (RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, mapping, parserContext));
        for (Map.Entry entry : mapping.entrySet()) {
            String fieldName = Strings.toUnderscoreCase((String)entry.getKey());
            Object fieldNode = entry.getValue();
            if ("_source".equals(fieldName) || "sourceField".equals(fieldName)) {
                docBuilder.sourceField(this.parseSourceField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_id".equals(fieldName) || "idField".equals(fieldName)) {
                docBuilder.idField(this.parseIdField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_index".equals(fieldName) || "indexField".equals(fieldName)) {
                docBuilder.indexField(this.parseIndexField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_type".equals(fieldName) || "typeField".equals(fieldName)) {
                docBuilder.typeField(this.parseTypeField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_uid".equals(fieldName) || "uidField".equals(fieldName)) {
                docBuilder.uidField(this.parseUidField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_routing".equals(fieldName)) {
                docBuilder.routingField(this.parseRoutingField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_parent".equals(fieldName)) {
                docBuilder.parentFiled(this.parseParentField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_boost".equals(fieldName) || "boostField".equals(fieldName)) {
                docBuilder.boostField(this.parseBoostField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_all".equals(fieldName) || "allField".equals(fieldName)) {
                docBuilder.allField(this.parseAllField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_analyzer".equals(fieldName)) {
                docBuilder.analyzerField(this.parseAnalyzerField((Map)fieldNode, parserContext));
                continue;
            }
            if ("index_analyzer".equals(fieldName)) {
                docBuilder.indexAnalyzer(this.analysisService.analyzer(fieldNode.toString()));
                continue;
            }
            if ("search_analyzer".equals(fieldName)) {
                docBuilder.searchAnalyzer(this.analysisService.analyzer(fieldNode.toString()));
                continue;
            }
            if (!"analyzer".equals(fieldName)) continue;
            docBuilder.indexAnalyzer(this.analysisService.analyzer(fieldNode.toString()));
            docBuilder.searchAnalyzer(this.analysisService.analyzer(fieldNode.toString()));
        }
        if (!docBuilder.hasIndexAnalyzer()) {
            docBuilder.indexAnalyzer(this.analysisService.defaultIndexAnalyzer());
        }
        if (!docBuilder.hasSearchAnalyzer()) {
            docBuilder.searchAnalyzer(this.analysisService.defaultSearchAnalyzer());
        }
        ImmutableMap<String, Object> attributes = ImmutableMap.of();
        if (mapping.containsKey("_meta")) {
            attributes = ImmutableMap.copyOf((Map)mapping.get("_meta"));
        }
        docBuilder.meta(attributes);
        XContentDocumentMapper documentMapper = docBuilder.build(this);
        documentMapper.refreshSource();
        return documentMapper;
    }

    private UidFieldMapper.Builder parseUidField(Map<String, Object> uidNode, XContentMapper.TypeParser.ParserContext parserContext) {
        UidFieldMapper.Builder builder = XContentMapperBuilders.uid();
        return builder;
    }

    private BoostFieldMapper.Builder parseBoostField(Map<String, Object> boostNode, XContentMapper.TypeParser.ParserContext parserContext) {
        String name = boostNode.get("name") == null ? "_boost" : boostNode.get("name").toString();
        BoostFieldMapper.Builder builder = XContentMapperBuilders.boost(name);
        XContentTypeParsers.parseNumberField(builder, name, boostNode, parserContext);
        for (Map.Entry<String, Object> entry : boostNode.entrySet()) {
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (!propName.equals("null_value")) continue;
            builder.nullValue(XContentMapValues.nodeFloatValue(propNode));
        }
        return builder;
    }

    private TypeFieldMapper.Builder parseTypeField(Map<String, Object> typeNode, XContentMapper.TypeParser.ParserContext parserContext) {
        TypeFieldMapper.Builder builder = XContentMapperBuilders.type();
        XContentTypeParsers.parseField(builder, builder.name, typeNode, parserContext);
        return builder;
    }

    private IdFieldMapper.Builder parseIdField(Map<String, Object> idNode, XContentMapper.TypeParser.ParserContext parserContext) {
        IdFieldMapper.Builder builder = XContentMapperBuilders.id();
        XContentTypeParsers.parseField(builder, builder.name, idNode, parserContext);
        return builder;
    }

    private RoutingFieldMapper.Builder parseRoutingField(Map<String, Object> routingNode, XContentMapper.TypeParser.ParserContext parserContext) {
        RoutingFieldMapper.Builder builder = XContentMapperBuilders.routing();
        XContentTypeParsers.parseField(builder, builder.name, routingNode, parserContext);
        for (Map.Entry<String, Object> entry : routingNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (fieldName.equals("required")) {
                builder.required(XContentMapValues.nodeBooleanValue(fieldNode));
                continue;
            }
            if (!fieldName.equals("path")) continue;
            builder.path(fieldNode.toString());
        }
        return builder;
    }

    private ParentFieldMapper.Builder parseParentField(Map<String, Object> parentNode, XContentMapper.TypeParser.ParserContext parserContext) {
        ParentFieldMapper.Builder builder = new ParentFieldMapper.Builder();
        for (Map.Entry<String, Object> entry : parentNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (!fieldName.equals("type")) continue;
            builder.type(fieldNode.toString());
        }
        return builder;
    }

    private AnalyzerMapper.Builder parseAnalyzerField(Map<String, Object> analyzerNode, XContentMapper.TypeParser.ParserContext parserContext) {
        AnalyzerMapper.Builder builder = XContentMapperBuilders.analyzer();
        for (Map.Entry<String, Object> entry : analyzerNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (!fieldName.equals("path")) continue;
            builder.field(fieldNode.toString());
        }
        return builder;
    }

    private AllFieldMapper.Builder parseAllField(Map<String, Object> allNode, XContentMapper.TypeParser.ParserContext parserContext) {
        AllFieldMapper.Builder builder = XContentMapperBuilders.all();
        XContentTypeParsers.parseField(builder, builder.name, allNode, parserContext);
        for (Map.Entry<String, Object> entry : allNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (!fieldName.equals("enabled")) continue;
            builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
        }
        return builder;
    }

    private SourceFieldMapper.Builder parseSourceField(Map<String, Object> sourceNode, XContentMapper.TypeParser.ParserContext parserContext) {
        SourceFieldMapper.Builder builder = XContentMapperBuilders.source();
        for (Map.Entry<String, Object> entry : sourceNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (fieldName.equals("enabled")) {
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                continue;
            }
            if (fieldName.equals("compress") && fieldNode != null) {
                builder.compress(XContentMapValues.nodeBooleanValue(fieldNode));
                continue;
            }
            if (!fieldName.equals("compress_threshold") || fieldNode == null) continue;
            if (fieldNode instanceof Number) {
                builder.compressThreshold(((Number)fieldNode).longValue());
                builder.compress(true);
                continue;
            }
            builder.compressThreshold(ByteSizeValue.parseBytesSizeValue(fieldNode.toString()).bytes());
            builder.compress(true);
        }
        return builder;
    }

    private IndexFieldMapper.Builder parseIndexField(Map<String, Object> indexNode, XContentMapper.TypeParser.ParserContext parserContext) {
        IndexFieldMapper.Builder builder = XContentMapperBuilders.index();
        XContentTypeParsers.parseField(builder, builder.name, indexNode, parserContext);
        for (Map.Entry<String, Object> entry : indexNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (!fieldName.equals("enabled")) continue;
            builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
        }
        return builder;
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, String source) throws MapperParsingException {
        Map<String, Object> root;
        XContentParser xContentParser = null;
        try {
            xContentParser = XContentFactory.xContent(source).createParser(source);
            root = xContentParser.map();
        }
        catch (IOException e) {
            throw new MapperParsingException("Failed to parse mapping definition", e);
        }
        finally {
            if (xContentParser != null) {
                xContentParser.close();
            }
        }
        if (root.keySet().size() != 1) {
            throw new MapperParsingException("Mapping must have the `type` as the root object");
        }
        String rootName = root.keySet().iterator().next();
        if (type == null) {
            type = rootName;
        }
        return new Tuple<String, Map<String, Object>>(type, (Map)root.get(rootName));
    }
}

