/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.util.concurrent.NotThreadSafe;
import org.elasticsearch.common.util.concurrent.ThreadSafe;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.ContentPath;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;

@ThreadSafe
public interface XContentMapper
extends ToXContent {
    public static final XContentMapper[] EMPTY_ARRAY = new XContentMapper[0];

    public String name();

    public void parse(ParseContext var1) throws IOException;

    public void merge(XContentMapper var1, MergeContext var2) throws MergeMappingException;

    public void traverse(FieldMapperListener var1);

    public static interface TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, ParserContext var3) throws MapperParsingException;

        public static class ParserContext {
            private final AnalysisService analysisService;
            private final ImmutableMap<String, TypeParser> typeParsers;

            public ParserContext(AnalysisService analysisService, ImmutableMap<String, TypeParser> typeParsers) {
                this.analysisService = analysisService;
                this.typeParsers = typeParsers;
            }

            public AnalysisService analysisService() {
                return this.analysisService;
            }

            public TypeParser typeParser(String type) {
                return this.typeParsers.get(Strings.toUnderscoreCase(type));
            }
        }
    }

    @NotThreadSafe
    public static abstract class Builder<T extends Builder, Y extends XContentMapper> {
        protected String name;
        protected T builder;

        protected Builder(String name) {
            this.name = name;
        }

        public abstract Y build(BuilderContext var1);
    }

    @NotThreadSafe
    public static class BuilderContext {
        private final ContentPath contentPath;

        public BuilderContext(ContentPath contentPath) {
            this.contentPath = contentPath;
        }

        public ContentPath path() {
            return this.contentPath;
        }
    }
}

