/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.policy;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.merge.policy.EnableMergePolicy;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.store.Store;

public class LogByteSizeMergePolicyProvider
extends AbstractIndexShardComponent
implements MergePolicyProvider<LogByteSizeMergePolicy> {
    private final ByteSizeValue minMergeSize;
    private final ByteSizeValue maxMergeSize;
    private final int mergeFactor;
    private final int maxMergeDocs;
    private final boolean calibrateSizeByDeletes;
    private boolean asyncMerge;

    @Inject
    public LogByteSizeMergePolicyProvider(Store store) {
        super(store.shardId(), store.indexSettings());
        Preconditions.checkNotNull(store, "Store must be provided to merge policy");
        this.minMergeSize = this.componentSettings.getAsBytesSize("min_merge_size", new ByteSizeValue(0x199999L, ByteSizeUnit.BYTES));
        this.maxMergeSize = this.componentSettings.getAsBytesSize("max_merge_size", new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.MB));
        this.mergeFactor = this.componentSettings.getAsInt("merge_factor", 10);
        this.maxMergeDocs = this.componentSettings.getAsInt("max_merge_docs", Integer.MAX_VALUE);
        this.calibrateSizeByDeletes = this.componentSettings.getAsBoolean("calibrate_size_by_deletes", true);
        this.asyncMerge = this.indexSettings.getAsBoolean("index.merge.async", true);
        this.logger.debug("using [log_bytes_size] merge policy with merge_factor[{}], min_merge_size[{}], max_merge_size[{}], max_merge_docs[{}], calibrate_size_by_deletes[{}], async_merge[{}]", this.mergeFactor, this.minMergeSize, this.maxMergeSize, this.maxMergeDocs, this.calibrateSizeByDeletes, this.asyncMerge);
    }

    @Override
    public LogByteSizeMergePolicy newMergePolicy(IndexWriter indexWriter) {
        EnableMergeLogByteSizeMergePolicy mergePolicy = this.asyncMerge ? new EnableMergeLogByteSizeMergePolicy(indexWriter) : new LogByteSizeMergePolicy(indexWriter);
        mergePolicy.setMinMergeMB(this.minMergeSize.mbFrac());
        mergePolicy.setMaxMergeMB(this.maxMergeSize.mbFrac());
        mergePolicy.setMergeFactor(this.mergeFactor);
        mergePolicy.setMaxMergeDocs(this.maxMergeDocs);
        mergePolicy.setCalibrateSizeByDeletes(this.calibrateSizeByDeletes);
        return mergePolicy;
    }

    public static class EnableMergeLogByteSizeMergePolicy
    extends LogByteSizeMergePolicy
    implements EnableMergePolicy {
        private final ThreadLocal<Boolean> enableMerge = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };

        public EnableMergeLogByteSizeMergePolicy(IndexWriter writer) {
            super(writer);
        }

        @Override
        public void enableMerge() {
            this.enableMerge.set(Boolean.TRUE);
        }

        @Override
        public void disableMerge() {
            this.enableMerge.set(Boolean.FALSE);
        }

        @Override
        public boolean isMergeEnabled() {
            return this.enableMerge.get() == Boolean.TRUE;
        }

        public void close() {
            this.enableMerge.remove();
            super.close();
        }

        public MergePolicy.MergeSpecification findMerges(SegmentInfos infos) throws IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMerges(infos);
        }

        public MergePolicy.MergeSpecification findMergesToExpungeDeletes(SegmentInfos segmentInfos) throws CorruptIndexException, IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMergesToExpungeDeletes(segmentInfos);
        }

        public MergePolicy.MergeSpecification findMergesForOptimize(SegmentInfos infos, int maxNumSegments, Set<SegmentInfo> segmentsToOptimize) throws IOException {
            if (this.enableMerge.get() == Boolean.FALSE) {
                return null;
            }
            return super.findMergesForOptimize(infos, maxNumSegments, segmentsToOptimize);
        }
    }
}

