/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.scheduler;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.merge.policy.EnableMergePolicy;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class SerialMergeSchedulerProvider
extends AbstractIndexShardComponent
implements MergeSchedulerProvider {
    @Inject
    public SerialMergeSchedulerProvider(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
        this.logger.trace("using [serial] merge scheduler", new Object[0]);
    }

    public MergeScheduler newMergeScheduler() {
        return new CustomSerialMergeScheduler();
    }

    public static class CustomSerialMergeScheduler
    extends SerialMergeScheduler {
        public void merge(IndexWriter writer) throws CorruptIndexException, IOException {
            try {
                if (writer.getMergePolicy() instanceof EnableMergePolicy && !((EnableMergePolicy)writer.getMergePolicy()).isMergeEnabled()) {
                    return;
                }
            }
            catch (AlreadyClosedException e) {
                return;
            }
            super.merge(writer);
        }
    }
}

