/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;
import org.elasticsearch.index.query.xcontent.XContentQueryBuilder;

public class HasChildQueryBuilder
extends BaseQueryBuilder {
    private final XContentQueryBuilder queryBuilder;
    private String childType;
    private String scope;
    private float boost = 1.0f;

    public HasChildQueryBuilder(String type, XContentQueryBuilder queryBuilder) {
        this.childType = type;
        this.queryBuilder = queryBuilder;
    }

    public HasChildQueryBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    public HasChildQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("has_child");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("type", this.childType);
        if (this.scope != null) {
            builder.field("_scope", this.scope);
        }
        if (this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

