/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.ElasticSearchInterruptedException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexShardAlreadyExistsException;
import org.elasticsearch.index.IndexShardMissingException;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.deletionpolicy.DeletionPolicyModule;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineModule;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.gateway.IndexGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayModule;
import org.elasticsearch.index.gateway.IndexShardGatewayService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.merge.policy.MergePolicyModule;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerModule;
import org.elasticsearch.index.percolator.PercolatorService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.IndexShardManagement;
import org.elasticsearch.index.shard.IndexShardModule;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreModule;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogModule;
import org.elasticsearch.index.translog.TranslogService;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.ShardsPluginsModule;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalIndexService
extends AbstractIndexComponent
implements IndexService {
    private final Injector injector;
    private final Settings indexSettings;
    private final NodeEnvironment nodeEnv;
    private final ThreadPool threadPool;
    private final PluginsService pluginsService;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final PercolatorService percolatorService;
    private final AnalysisService analysisService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final SimilarityService similarityService;
    private final IndexCache indexCache;
    private final IndexEngine indexEngine;
    private final IndexGateway indexGateway;
    private final IndexStore indexStore;
    private volatile ImmutableMap<Integer, Injector> shardsInjectors = ImmutableMap.of();
    private volatile ImmutableMap<Integer, IndexShard> shards = ImmutableMap.of();
    private volatile boolean closed = false;
    private final CleanCacheOnIndicesLifecycleListener cleanCacheOnIndicesLifecycleListener = new CleanCacheOnIndicesLifecycleListener();

    @Inject
    public InternalIndexService(Injector injector, Index index, @IndexSettings Settings indexSettings, NodeEnvironment nodeEnv, ThreadPool threadPool, PercolatorService percolatorService, AnalysisService analysisService, MapperService mapperService, IndexQueryParserService queryParserService, SimilarityService similarityService, IndexCache indexCache, IndexEngine indexEngine, IndexGateway indexGateway, IndexStore indexStore) {
        super(index, indexSettings);
        this.injector = injector;
        this.nodeEnv = nodeEnv;
        this.threadPool = threadPool;
        this.indexSettings = indexSettings;
        this.percolatorService = percolatorService;
        this.analysisService = analysisService;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.similarityService = similarityService;
        this.indexCache = indexCache;
        this.indexEngine = indexEngine;
        this.indexGateway = indexGateway;
        this.indexStore = indexStore;
        this.pluginsService = injector.getInstance(PluginsService.class);
        this.indicesLifecycle = (InternalIndicesLifecycle)injector.getInstance(IndicesLifecycle.class);
        this.indicesLifecycle.addListener(this.cleanCacheOnIndicesLifecycleListener);
    }

    @Override
    public int numberOfShards() {
        return this.shards.size();
    }

    @Override
    public UnmodifiableIterator<IndexShard> iterator() {
        return ((ImmutableCollection)this.shards.values()).iterator();
    }

    @Override
    public boolean hasShard(int shardId) {
        return this.shards.containsKey(shardId);
    }

    @Override
    public IndexShard shard(int shardId) {
        return this.shards.get(shardId);
    }

    @Override
    public IndexShard shardSafe(int shardId) throws IndexShardMissingException {
        IndexShard indexShard = this.shard(shardId);
        if (indexShard == null) {
            throw new IndexShardMissingException(new ShardId(this.index, shardId));
        }
        return indexShard;
    }

    @Override
    public ImmutableSet<Integer> shardIds() {
        return ImmutableSet.copyOf(this.shards.keySet());
    }

    @Override
    public Injector injector() {
        return this.injector;
    }

    @Override
    public IndexGateway gateway() {
        return this.indexGateway;
    }

    @Override
    public IndexStore store() {
        return this.indexStore;
    }

    @Override
    public IndexCache cache() {
        return this.indexCache;
    }

    @Override
    public PercolatorService percolateService() {
        return this.percolatorService;
    }

    @Override
    public AnalysisService analysisService() {
        return this.analysisService;
    }

    @Override
    public MapperService mapperService() {
        return this.mapperService;
    }

    @Override
    public IndexQueryParserService queryParserService() {
        return this.queryParserService;
    }

    @Override
    public SimilarityService similarityService() {
        return this.similarityService;
    }

    @Override
    public IndexEngine engine() {
        return this.indexEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(final boolean delete, final String reason) {
        InternalIndexService internalIndexService = this;
        synchronized (internalIndexService) {
            this.closed = true;
        }
        try {
            ImmutableSet<Integer> shardIds = this.shardIds();
            final CountDownLatch latch = new CountDownLatch(shardIds.size());
            Iterator i$ = shardIds.iterator();
            while (i$.hasNext()) {
                final int shardId = (Integer)i$.next();
                this.threadPool.cached().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            InternalIndexService.this.deleteShard(shardId, delete, !delete, delete, reason);
                        }
                        catch (Exception e) {
                            InternalIndexService.this.logger.warn("failed to close shard, delete [{}]", e, delete);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new ElasticSearchInterruptedException("interrupted closing index [ " + this.index().name() + "]", e);
            }
        }
        finally {
            this.indicesLifecycle.removeListener(this.cleanCacheOnIndicesLifecycleListener);
        }
    }

    @Override
    public Injector shardInjector(int shardId) throws ElasticSearchException {
        return this.shardsInjectors.get(shardId);
    }

    @Override
    public Injector shardInjectorSafe(int shardId) throws IndexShardMissingException {
        Injector shardInjector = this.shardInjector(shardId);
        if (shardInjector == null) {
            throw new IndexShardMissingException(new ShardId(this.index, shardId));
        }
        return shardInjector;
    }

    @Override
    public synchronized IndexShard createShard(int sShardId) throws ElasticSearchException {
        if (this.closed) {
            throw new ElasticSearchIllegalStateException("Can't create shard [" + this.index.name() + "][" + sShardId + "], closed");
        }
        ShardId shardId = new ShardId(this.index, sShardId);
        if (this.shardsInjectors.containsKey(shardId.id())) {
            throw new IndexShardAlreadyExistsException(shardId + " already exists");
        }
        this.indicesLifecycle.beforeIndexShardCreated(shardId);
        this.logger.debug("creating shard_id [{}]", shardId.id());
        ModulesBuilder modules = new ModulesBuilder();
        modules.add((Module)new ShardsPluginsModule(this.indexSettings, this.pluginsService));
        modules.add((Module)new IndexShardModule(shardId));
        modules.add((Module)new StoreModule(this.indexSettings, this.injector.getInstance(IndexStore.class)));
        modules.add((Module)new DeletionPolicyModule(this.indexSettings));
        modules.add((Module)new MergePolicyModule(this.indexSettings));
        modules.add((Module)new MergeSchedulerModule(this.indexSettings));
        modules.add((Module)new TranslogModule(this.indexSettings));
        modules.add((Module)new EngineModule(this.indexSettings));
        modules.add((Module)new IndexShardGatewayModule(this.injector.getInstance(IndexGateway.class)));
        Injector shardInjector = modules.createChildInjector(this.injector);
        this.shardsInjectors = MapBuilder.newMapBuilder(this.shardsInjectors).put(shardId.id(), shardInjector).immutableMap();
        IndexShard indexShard = shardInjector.getInstance(IndexShard.class);
        this.indicesLifecycle.afterIndexShardCreated(indexShard);
        this.shards = MapBuilder.newMapBuilder(this.shards).put(shardId.id(), indexShard).immutableMap();
        return indexShard;
    }

    @Override
    public synchronized void cleanShard(int shardId, String reason) throws ElasticSearchException {
        this.deleteShard(shardId, true, false, false, reason);
    }

    @Override
    public synchronized void removeShard(int shardId, String reason) throws ElasticSearchException {
        this.deleteShard(shardId, false, false, false, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteShard(int shardId, boolean delete, boolean snapshotGateway, boolean deleteGateway, String reason) throws ElasticSearchException {
        IndexShard indexShard;
        Injector shardInjector;
        InternalIndexService internalIndexService = this;
        synchronized (internalIndexService) {
            HashMap<Integer, Injector> tmpShardInjectors = Maps.newHashMap(this.shardsInjectors);
            shardInjector = (Injector)tmpShardInjectors.remove(shardId);
            if (shardInjector == null) {
                if (!delete) {
                    return;
                }
                throw new IndexShardMissingException(new ShardId(this.index, shardId));
            }
            this.shardsInjectors = ImmutableMap.copyOf(tmpShardInjectors);
            if (delete) {
                this.logger.debug("deleting shard_id [{}]", shardId);
            }
            HashMap<Integer, IndexShard> tmpShardsMap = Maps.newHashMap(this.shards);
            indexShard = (IndexShard)tmpShardsMap.remove(shardId);
            this.shards = ImmutableMap.copyOf(tmpShardsMap);
        }
        ShardId sId = new ShardId(this.index, shardId);
        this.indicesLifecycle.beforeIndexShardClosed(sId, indexShard, delete);
        for (Class<? extends CloseableIndexComponent> closeable : this.pluginsService.shardServices()) {
            try {
                shardInjector.getInstance(closeable).close(delete);
            }
            catch (Exception e) {
                this.logger.debug("failed to clean plugin shard service [{}]", e, closeable);
            }
        }
        try {
            shardInjector.getInstance(TranslogService.class).close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (indexShard != null) {
            shardInjector.getInstance(IndexShardManagement.class).close();
        }
        if (indexShard != null) {
            ((InternalIndexShard)indexShard).close(reason);
        }
        try {
            shardInjector.getInstance(Engine.class).close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (snapshotGateway) {
                shardInjector.getInstance(IndexShardGatewayService.class).snapshotOnClose();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            shardInjector.getInstance(IndexShardGatewayService.class).close(deleteGateway);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            shardInjector.getInstance(Translog.class).close(delete);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.indicesLifecycle.afterIndexShardClosed(sId, delete);
        Store store = shardInjector.getInstance(Store.class);
        if (delete || this.indexGateway.type().equals("none") || !this.indexStore.persistent()) {
            try {
                store.fullDelete();
            }
            catch (IOException e) {
                this.logger.warn("failed to clean store on shard deletion", e, new Object[0]);
            }
        }
        try {
            store.close();
        }
        catch (IOException e) {
            this.logger.warn("failed to close store on shard deletion", e, new Object[0]);
        }
        Injectors.close(this.injector);
        if (delete || this.indexGateway.type().equals("none")) {
            FileSystemUtils.deleteRecursively(this.nodeEnv.shardLocation(sId));
        }
    }

    class CleanCacheOnIndicesLifecycleListener
    extends IndicesLifecycle.Listener {
        CleanCacheOnIndicesLifecycleListener() {
        }

        @Override
        public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, boolean delete) {
            InternalIndexService.this.indexCache.clearUnreferenced();
        }

        @Override
        public void afterIndexShardClosed(ShardId shardId, boolean delete) {
            InternalIndexService.this.indexCache.clearUnreferenced();
        }
    }
}

