/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class StoreFileMetaData
implements Streamable {
    private String name;
    private long lastModified;
    private long length;
    private String checksum;

    StoreFileMetaData() {
    }

    public StoreFileMetaData(String name, long length, long lastModified, String checksum) {
        this.name = name;
        this.lastModified = lastModified;
        this.length = length;
        this.checksum = checksum;
    }

    public String name() {
        return this.name;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long length() {
        return this.length;
    }

    @Nullable
    public String checksum() {
        return this.checksum;
    }

    public boolean isSame(StoreFileMetaData other) {
        if (this.checksum != null && other.checksum != null) {
            return this.checksum.equals(other.checksum);
        }
        return this.length == other.length;
    }

    public static StoreFileMetaData readStoreFileMetaData(StreamInput in) throws IOException {
        StoreFileMetaData md = new StoreFileMetaData();
        md.readFrom(in);
        return md;
    }

    public String toString() {
        return "name [" + this.name + "], length [" + this.length + "], checksum [" + this.checksum + "]";
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.length = in.readVLong();
        if (in.readBoolean()) {
            this.checksum = in.readUTF();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeVLong(this.length);
        if (this.checksum == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.checksum);
        }
    }
}

