/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class NodeIndicesStats
implements Streamable,
Serializable,
ToXContent {
    private ByteSizeValue storeSize;
    private ByteSizeValue fieldCacheSize;
    private ByteSizeValue filterCacheSize;
    private long fieldCacheEvictions;

    NodeIndicesStats() {
    }

    public NodeIndicesStats(ByteSizeValue storeSize, ByteSizeValue fieldCacheSize, ByteSizeValue filterCacheSize, long fieldCacheEvictions) {
        this.storeSize = storeSize;
        this.fieldCacheSize = fieldCacheSize;
        this.filterCacheSize = filterCacheSize;
        this.fieldCacheEvictions = fieldCacheEvictions;
    }

    public ByteSizeValue storeSize() {
        return this.storeSize;
    }

    public ByteSizeValue getStoreSize() {
        return this.storeSize;
    }

    public ByteSizeValue fieldCacheSize() {
        return this.fieldCacheSize;
    }

    public ByteSizeValue getFieldCacheSize() {
        return this.fieldCacheSize;
    }

    public ByteSizeValue filterCacheSize() {
        return this.filterCacheSize;
    }

    public ByteSizeValue getFilterCacheSize() {
        return this.filterCacheSize;
    }

    public long fieldCacheEvictions() {
        return this.fieldCacheEvictions;
    }

    public long getFieldCacheEvictions() {
        return this.fieldCacheEvictions();
    }

    public static NodeIndicesStats readIndicesStats(StreamInput in) throws IOException {
        NodeIndicesStats stats = new NodeIndicesStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.storeSize = ByteSizeValue.readBytesSizeValue(in);
        this.fieldCacheSize = ByteSizeValue.readBytesSizeValue(in);
        this.filterCacheSize = ByteSizeValue.readBytesSizeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.storeSize.writeTo(out);
        this.fieldCacheSize.writeTo(out);
        this.filterCacheSize.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.INDICES);
        builder.field(Fields.STORE_SIZE, this.storeSize.toString());
        builder.field(Fields.STORE_SIZE_IN_BYTES, this.storeSize.bytes());
        builder.field(Fields.FIELD_CACHE_EVICTIONS, this.fieldCacheEvictions);
        builder.field(Fields.FIELD_CACHE_SIZE, this.fieldCacheSize.toString());
        builder.field(Fields.FIELD_CACHE_SIZE_IN_BYTES, this.fieldCacheSize.bytes());
        builder.field(Fields.FILTER_CACHE_SIZE, this.filterCacheSize.toString());
        builder.field(Fields.FILTER_CACHE_SIZE_IN_BYTES, this.filterCacheSize.bytes());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString STORE_SIZE = new XContentBuilderString("store_size");
        static final XContentBuilderString STORE_SIZE_IN_BYTES = new XContentBuilderString("store_size_in_bytes");
        static final XContentBuilderString FIELD_CACHE_SIZE = new XContentBuilderString("field_cache_size");
        static final XContentBuilderString FIELD_CACHE_SIZE_IN_BYTES = new XContentBuilderString("field_cache_size_in_bytes");
        static final XContentBuilderString FIELD_CACHE_EVICTIONS = new XContentBuilderString("field_cache_evictions");
        static final XContentBuilderString FILTER_CACHE_SIZE = new XContentBuilderString("filter_cache_size");
        static final XContentBuilderString FILTER_CACHE_SIZE_IN_BYTES = new XContentBuilderString("filter_cache_size_in_bytes");

        Fields() {
        }
    }
}

