/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.store;

import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndicesService;

public class IndicesStore
extends AbstractComponent
implements ClusterStateListener {
    private final IndicesService indicesService;
    private final ClusterService clusterService;

    @Inject
    public IndicesStore(Settings settings, IndicesService indicesService, ClusterService clusterService) {
        super(settings);
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        clusterService.add(this);
    }

    public void close() {
        this.clusterService.remove(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.routingTableChanged()) {
            return;
        }
        RoutingTable routingTable = event.state().routingTable();
        for (IndexRoutingTable indexRoutingTable : routingTable) {
            IndexService indexService = this.indicesService.indexService(indexRoutingTable.index());
            if (indexService == null || !indexService.store().persistent()) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                if (indexService.hasShard(indexShardRoutingTable.shardId().id()) || !indexService.store().canDeleteUnallocated(indexShardRoutingTable.shardId()) || indexShardRoutingTable.countWithState(ShardRoutingState.STARTED) != indexShardRoutingTable.size()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] deleting unallocated shard", indexShardRoutingTable.shardId().index().name(), indexShardRoutingTable.shardId().id());
                }
                try {
                    indexService.store().deleteUnallocated(indexShardRoutingTable.shardId());
                }
                catch (Exception e) {
                    this.logger.debug("[{}][{}] failed to delete unallocated shard, ignoring", e, indexShardRoutingTable.shardId().index().name(), indexShardRoutingTable.shardId().id());
                }
            }
        }
    }
}

