/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class JvmInfo
implements Streamable,
Serializable,
ToXContent {
    private static JvmInfo INSTANCE;
    long pid = -1L;
    String vmName = "";
    String vmVersion = "";
    String vmVendor = "";
    long startTime = -1L;
    Mem mem;
    String[] inputArguments;
    String bootClassPath;
    String classPath;
    Map<String, String> systemProperties;

    public static JvmInfo jvmInfo() {
        return INSTANCE;
    }

    private JvmInfo() {
    }

    public long pid() {
        return this.pid;
    }

    public long getPid() {
        return this.pid;
    }

    public String vmName() {
        return this.vmName;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String vmVersion() {
        return this.vmVersion;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String vmVendor() {
        return this.vmVendor;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public long startTime() {
        return this.startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    public String[] inputArguments() {
        return this.inputArguments;
    }

    public String[] getInputArguments() {
        return this.inputArguments;
    }

    public String bootClassPath() {
        return this.bootClassPath;
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public String classPath() {
        return this.classPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public Map<String, String> systemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("jvm");
        builder.field("pid", this.pid);
        builder.field("vm_name", this.vmName);
        builder.field("vm_version", this.vmVersion);
        builder.field("vm_vendor", this.vmVendor);
        builder.field("start_time", this.startTime);
        builder.endObject();
        return builder;
    }

    public static JvmInfo readJvmInfo(StreamInput in) throws IOException {
        JvmInfo jvmInfo = new JvmInfo();
        jvmInfo.readFrom(in);
        return jvmInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.pid = in.readLong();
        this.vmName = in.readUTF();
        this.vmVersion = in.readUTF();
        this.vmVendor = in.readUTF();
        this.startTime = in.readLong();
        this.inputArguments = new String[in.readInt()];
        for (int i = 0; i < this.inputArguments.length; ++i) {
            this.inputArguments[i] = in.readUTF();
        }
        this.bootClassPath = in.readUTF();
        this.classPath = in.readUTF();
        this.systemProperties = new HashMap<String, String>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.systemProperties.put(in.readUTF(), in.readUTF());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.pid);
        out.writeUTF(this.vmName);
        out.writeUTF(this.vmVersion);
        out.writeUTF(this.vmVendor);
        out.writeLong(this.startTime);
        out.writeInt(this.inputArguments.length);
        for (String inputArgument : this.inputArguments) {
            out.writeUTF(inputArgument);
        }
        out.writeUTF(this.bootClassPath);
        out.writeUTF(this.classPath);
        out.writeInt(this.systemProperties.size());
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
    }

    static {
        long pid;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        String xPid = runtimeMXBean.getName();
        try {
            xPid = xPid.split("@")[0];
            pid = Long.parseLong(xPid);
        }
        catch (Exception e) {
            pid = -1L;
        }
        JvmInfo info = new JvmInfo();
        info.pid = pid;
        info.startTime = runtimeMXBean.getStartTime();
        info.vmName = runtimeMXBean.getVmName();
        info.vmVendor = runtimeMXBean.getVmVendor();
        info.vmVersion = runtimeMXBean.getVmVersion();
        info.mem = new Mem();
        info.mem.heapInit = memoryMXBean.getHeapMemoryUsage().getInit();
        info.mem.heapMax = memoryMXBean.getHeapMemoryUsage().getMax();
        info.mem.nonHeapInit = memoryMXBean.getNonHeapMemoryUsage().getInit();
        info.mem.nonHeapMax = memoryMXBean.getNonHeapMemoryUsage().getMax();
        info.inputArguments = runtimeMXBean.getInputArguments().toArray(new String[runtimeMXBean.getInputArguments().size()]);
        info.bootClassPath = runtimeMXBean.getBootClassPath();
        info.classPath = runtimeMXBean.getClassPath();
        info.systemProperties = runtimeMXBean.getSystemProperties();
        INSTANCE = info;
    }

    public static class Mem
    implements Streamable,
    Serializable {
        long heapInit = -1L;
        long heapMax = -1L;
        long nonHeapInit = -1L;
        long nonHeapMax = -1L;

        Mem() {
        }

        public ByteSizeValue heapInit() {
            return new ByteSizeValue(this.heapInit);
        }

        public ByteSizeValue getHeapInit() {
            return this.heapInit();
        }

        public ByteSizeValue heapMax() {
            return new ByteSizeValue(this.heapMax);
        }

        public ByteSizeValue getHeapMax() {
            return this.heapMax();
        }

        public ByteSizeValue nonHeapInit() {
            return new ByteSizeValue(this.nonHeapInit);
        }

        public ByteSizeValue getNonHeapInit() {
            return this.nonHeapInit();
        }

        public ByteSizeValue nonHeapMax() {
            return new ByteSizeValue(this.nonHeapMax);
        }

        public ByteSizeValue getNonHeapMax() {
            return this.nonHeapMax();
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.heapInit = in.readVLong();
            this.heapMax = in.readVLong();
            this.nonHeapInit = in.readVLong();
            this.nonHeapMax = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.heapInit);
            out.writeVLong(this.heapMax);
            out.writeVLong(this.nonHeapInit);
            out.writeVLong(this.nonHeapMax);
        }
    }
}

