/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class JvmStats
implements Streamable,
Serializable,
ToXContent {
    private static final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static boolean sunGc;
    private static Method getLastGcInfoMethod;
    private static Method getMemoryUsageBeforeGcMethod;
    private static Method getMemoryUsageAfterGcMethod;
    private static Method getStartTimeMethod;
    private static Method getEndTimeMethod;
    private static Method getDurationMethod;
    long timestamp = -1L;
    long uptime;
    Mem mem;
    Threads threads;
    GarbageCollectors gc;

    public static JvmStats jvmStats() {
        JvmStats stats = new JvmStats(System.currentTimeMillis(), runtimeMXBean.getUptime());
        stats.mem = new Mem();
        MemoryUsage memUsage = memoryMXBean.getHeapMemoryUsage();
        stats.mem.heapUsed = memUsage.getUsed();
        stats.mem.heapCommitted = memUsage.getCommitted();
        memUsage = memoryMXBean.getNonHeapMemoryUsage();
        stats.mem.nonHeapUsed = memUsage.getUsed();
        stats.mem.nonHeapCommitted = memUsage.getCommitted();
        stats.threads = new Threads();
        stats.threads.count = threadMXBean.getThreadCount();
        stats.threads.peakCount = threadMXBean.getPeakThreadCount();
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        stats.gc = new GarbageCollectors();
        GarbageCollectors.access$002(stats.gc, new GarbageCollector[gcMxBeans.size()]);
        for (int i = 0; i < stats.gc.collectors.length; ++i) {
            GarbageCollectorMXBean gcMxBean = gcMxBeans.get(i);
            ((GarbageCollectors)stats.gc).collectors[i] = new GarbageCollector();
            ((GarbageCollectors)stats.gc).collectors[i].name = gcMxBean.getName();
            ((GarbageCollectors)stats.gc).collectors[i].collectionCount = gcMxBean.getCollectionCount();
            ((GarbageCollectors)stats.gc).collectors[i].collectionTime = gcMxBean.getCollectionTime();
            if (!sunGc) continue;
            try {
                Object lastGcInfo = getLastGcInfoMethod.invoke((Object)gcMxBean, new Object[0]);
                if (lastGcInfo == null) continue;
                Map usageBeforeGc = (Map)getMemoryUsageBeforeGcMethod.invoke(lastGcInfo, new Object[0]);
                Map usageAfterGc = (Map)getMemoryUsageAfterGcMethod.invoke(lastGcInfo, new Object[0]);
                long startTime = (Long)getStartTimeMethod.invoke(lastGcInfo, new Object[0]);
                long endTime = (Long)getEndTimeMethod.invoke(lastGcInfo, new Object[0]);
                long duration = (Long)getDurationMethod.invoke(lastGcInfo, new Object[0]);
                long previousMemoryUsed = 0L;
                long memoryUsed = 0L;
                long memoryMax = 0L;
                for (Map.Entry entry : usageBeforeGc.entrySet()) {
                    previousMemoryUsed += ((MemoryUsage)entry.getValue()).getUsed();
                }
                for (Map.Entry entry : usageAfterGc.entrySet()) {
                    MemoryUsage mu = (MemoryUsage)entry.getValue();
                    memoryUsed += mu.getUsed();
                    memoryMax += mu.getMax();
                }
                ((GarbageCollectors)stats.gc).collectors[i].lastGc = new GarbageCollector.LastGc(startTime, endTime, memoryMax, previousMemoryUsed, memoryUsed, duration);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return stats;
    }

    private JvmStats() {
    }

    public JvmStats(long timestamp, long uptime) {
        this.timestamp = timestamp;
        this.uptime = uptime;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public TimeValue uptime() {
        return new TimeValue(this.uptime);
    }

    public TimeValue getUptime() {
        return this.uptime();
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    public Threads threads() {
        return this.threads;
    }

    public Threads getThreads() {
        return this.threads();
    }

    public GarbageCollectors gc() {
        return this.gc;
    }

    public GarbageCollectors getGc() {
        return this.gc();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("jvm");
        builder.field("timestamp", this.timestamp);
        builder.field("uptime", this.uptime().format());
        builder.field("uptime_in_millis", this.uptime().millis());
        if (this.mem != null) {
            builder.startObject("mem");
            builder.field("heap_used", this.mem.heapUsed().toString());
            builder.field("heap_used_in_bytes", this.mem.heapUsed().bytes());
            builder.field("heap_committed", this.mem.heapCommitted().toString());
            builder.field("heap_committed_in_bytes", this.mem.heapCommitted().bytes());
            builder.field("non_heap_used", this.mem.nonHeapUsed().toString());
            builder.field("non_heap_used_in_bytes", this.mem.nonHeapUsed().bytes());
            builder.field("non_heap_committed", this.mem.nonHeapCommitted().toString());
            builder.field("non_heap_committed_in_bytes", this.mem.nonHeapCommitted().bytes());
            builder.endObject();
        }
        if (this.threads != null) {
            builder.startObject("threads");
            builder.field("count", this.threads.count());
            builder.field("peak_count", this.threads.peakCount());
            builder.endObject();
        }
        if (this.gc != null) {
            builder.startObject("gc");
            builder.field("collection_count", this.gc.collectionCount());
            builder.field("collection_time", this.gc.collectionTime().format());
            builder.field("collection_time_in_millis", this.gc.collectionTime().millis());
            builder.startObject("collectors");
            for (GarbageCollector collector : this.gc) {
                builder.startObject(collector.name());
                builder.field("collection_count", collector.collectionCount());
                builder.field("collection_time", collector.collectionTime().format());
                builder.field("collection_time_in_millis", collector.collectionTime().millis());
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static JvmStats readJvmStats(StreamInput in) throws IOException {
        JvmStats jvmStats = new JvmStats();
        jvmStats.readFrom(in);
        return jvmStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.uptime = in.readVLong();
        this.mem = Mem.readMem(in);
        this.threads = Threads.readThreads(in);
        this.gc = GarbageCollectors.readGarbageCollectors(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeVLong(this.uptime);
        this.mem.writeTo(out);
        this.threads.writeTo(out);
        this.gc.writeTo(out);
    }

    static {
        try {
            Class<?> sunGcClass = Class.forName("com.sun.management.GarbageCollectorMXBean");
            Class<?> gcInfoClass = Class.forName("com.sun.management.GcInfo");
            getLastGcInfoMethod = sunGcClass.getDeclaredMethod("getLastGcInfo", new Class[0]);
            getLastGcInfoMethod.setAccessible(true);
            getMemoryUsageBeforeGcMethod = gcInfoClass.getDeclaredMethod("getMemoryUsageBeforeGc", new Class[0]);
            getMemoryUsageBeforeGcMethod.setAccessible(true);
            getMemoryUsageAfterGcMethod = gcInfoClass.getDeclaredMethod("getMemoryUsageAfterGc", new Class[0]);
            getMemoryUsageAfterGcMethod.setAccessible(true);
            getStartTimeMethod = gcInfoClass.getDeclaredMethod("getStartTime", new Class[0]);
            getStartTimeMethod.setAccessible(true);
            getEndTimeMethod = gcInfoClass.getDeclaredMethod("getEndTime", new Class[0]);
            getEndTimeMethod.setAccessible(true);
            getDurationMethod = gcInfoClass.getDeclaredMethod("getDuration", new Class[0]);
            getDurationMethod.setAccessible(true);
            sunGc = true;
        }
        catch (Throwable ex) {
            sunGc = false;
        }
    }

    public static class Mem
    implements Streamable,
    Serializable {
        long heapCommitted;
        long heapUsed;
        long nonHeapCommitted;
        long nonHeapUsed;

        Mem() {
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.heapCommitted = in.readVLong();
            this.heapUsed = in.readVLong();
            this.nonHeapCommitted = in.readVLong();
            this.nonHeapUsed = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.heapCommitted);
            out.writeVLong(this.heapUsed);
            out.writeVLong(this.nonHeapCommitted);
            out.writeVLong(this.nonHeapUsed);
        }

        public ByteSizeValue heapCommitted() {
            return new ByteSizeValue(this.heapCommitted);
        }

        public ByteSizeValue getHeapCommitted() {
            return this.heapCommitted();
        }

        public ByteSizeValue heapUsed() {
            return new ByteSizeValue(this.heapUsed);
        }

        public ByteSizeValue getHeapUsed() {
            return this.heapUsed();
        }

        public ByteSizeValue nonHeapCommitted() {
            return new ByteSizeValue(this.nonHeapCommitted);
        }

        public ByteSizeValue getNonHeapCommitted() {
            return this.nonHeapCommitted();
        }

        public ByteSizeValue nonHeapUsed() {
            return new ByteSizeValue(this.nonHeapUsed);
        }

        public ByteSizeValue getNonHeapUsed() {
            return this.nonHeapUsed();
        }
    }

    public static class Threads
    implements Streamable,
    Serializable {
        int count;
        int peakCount;

        Threads() {
        }

        public int count() {
            return this.count;
        }

        public int getCount() {
            return this.count();
        }

        public int peakCount() {
            return this.peakCount;
        }

        public int getPeakCount() {
            return this.peakCount();
        }

        public static Threads readThreads(StreamInput in) throws IOException {
            Threads threads = new Threads();
            threads.readFrom(in);
            return threads;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.count = in.readVInt();
            this.peakCount = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.count);
            out.writeVInt(this.peakCount);
        }
    }

    public static class GarbageCollector
    implements Streamable,
    Serializable {
        String name;
        long collectionCount;
        long collectionTime;
        LastGc lastGc;

        GarbageCollector() {
        }

        public static GarbageCollector readGarbageCollector(StreamInput in) throws IOException {
            GarbageCollector gc = new GarbageCollector();
            gc.readFrom(in);
            return gc;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readUTF();
            this.collectionCount = in.readVLong();
            this.collectionTime = in.readVLong();
            if (in.readBoolean()) {
                this.lastGc = LastGc.readLastGc(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeVLong(this.collectionCount);
            out.writeVLong(this.collectionTime);
            if (this.lastGc == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.lastGc.writeTo(out);
            }
        }

        public String name() {
            return this.name;
        }

        public String getName() {
            return this.name();
        }

        public long collectionCount() {
            return this.collectionCount;
        }

        public long getCollectionCount() {
            return this.collectionCount();
        }

        public TimeValue collectionTime() {
            return new TimeValue(this.collectionTime, TimeUnit.MILLISECONDS);
        }

        public TimeValue getCollectionTime() {
            return this.collectionTime();
        }

        public LastGc lastGc() {
            return this.lastGc;
        }

        public LastGc getLastGc() {
            return this.lastGc();
        }

        public static class LastGc
        implements Streamable {
            long startTime;
            long endTime;
            long max;
            long beforeUsed;
            long afterUsed;
            long duration;

            LastGc() {
            }

            public LastGc(long startTime, long endTime, long max, long beforeUsed, long afterUsed, long duration) {
                this.startTime = startTime;
                this.endTime = endTime;
                this.max = max;
                this.beforeUsed = beforeUsed;
                this.afterUsed = afterUsed;
                this.duration = duration;
            }

            public long startTime() {
                return this.startTime;
            }

            public long getStartTime() {
                return this.startTime();
            }

            public long endTime() {
                return this.endTime;
            }

            public long getEndTime() {
                return this.endTime();
            }

            public ByteSizeValue max() {
                return new ByteSizeValue(this.max);
            }

            public ByteSizeValue getMax() {
                return this.max();
            }

            public ByteSizeValue afterUsed() {
                return new ByteSizeValue(this.afterUsed);
            }

            public ByteSizeValue getAfterUsed() {
                return this.afterUsed();
            }

            public ByteSizeValue beforeUsed() {
                return new ByteSizeValue(this.beforeUsed);
            }

            public ByteSizeValue getBeforeUsed() {
                return this.beforeUsed();
            }

            public ByteSizeValue reclaimed() {
                return new ByteSizeValue(this.beforeUsed - this.afterUsed);
            }

            public ByteSizeValue getReclaimed() {
                return this.reclaimed();
            }

            public TimeValue duration() {
                return new TimeValue(this.duration);
            }

            public TimeValue getDuration() {
                return this.duration();
            }

            public static LastGc readLastGc(StreamInput in) throws IOException {
                LastGc lastGc = new LastGc();
                lastGc.readFrom(in);
                return lastGc;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                this.startTime = in.readVLong();
                this.endTime = in.readVLong();
                this.max = in.readVLong();
                this.beforeUsed = in.readVLong();
                this.afterUsed = in.readVLong();
                this.duration = in.readVLong();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeVLong(this.startTime);
                out.writeVLong(this.endTime);
                out.writeVLong(this.max);
                out.writeVLong(this.beforeUsed);
                out.writeVLong(this.afterUsed);
                out.writeVLong(this.duration);
            }
        }
    }

    public static class GarbageCollectors
    implements Streamable,
    Serializable,
    Iterable<GarbageCollector> {
        private GarbageCollector[] collectors;

        GarbageCollectors() {
        }

        public static GarbageCollectors readGarbageCollectors(StreamInput in) throws IOException {
            GarbageCollectors collectors = new GarbageCollectors();
            collectors.readFrom(in);
            return collectors;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.collectors = new GarbageCollector[in.readVInt()];
            for (int i = 0; i < this.collectors.length; ++i) {
                this.collectors[i] = GarbageCollector.readGarbageCollector(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.collectors.length);
            for (GarbageCollector gc : this.collectors) {
                gc.writeTo(out);
            }
        }

        public GarbageCollector[] collectors() {
            return this.collectors;
        }

        @Override
        public Iterator iterator() {
            return Iterators.forArray(this.collectors);
        }

        public long collectionCount() {
            long collectionCount = 0L;
            for (GarbageCollector gc : this.collectors) {
                collectionCount += gc.collectionCount();
            }
            return collectionCount;
        }

        public TimeValue collectionTime() {
            long collectionTime = 0L;
            for (GarbageCollector gc : this.collectors) {
                collectionTime += gc.collectionTime;
            }
            return new TimeValue(collectionTime, TimeUnit.MILLISECONDS);
        }

        static /* synthetic */ GarbageCollector[] access$002(GarbageCollectors x0, GarbageCollector[] x1) {
            x0.collectors = x1;
            return x1;
        }
    }
}

