/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node.internal;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.TransportActionModule;
import org.elasticsearch.cache.NodeCache;
import org.elasticsearch.cache.NodeCacheModule;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClientModule;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterNameModule;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.EnvironmentModule;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeEnvironmentModule;
import org.elasticsearch.gateway.GatewayModule;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.http.HttpServerModule;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.jmx.JmxModule;
import org.elasticsearch.jmx.JmxService;
import org.elasticsearch.monitor.MonitorModule;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalSettingsPerparer;
import org.elasticsearch.node.internal.NodeModule;
import org.elasticsearch.plugins.PluginsModule;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.river.RiversManager;
import org.elasticsearch.river.RiversModule;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolModule;
import org.elasticsearch.transport.TransportModule;
import org.elasticsearch.transport.TransportService;

public final class InternalNode
implements Node {
    private final Lifecycle lifecycle = new Lifecycle();
    private final Injector injector;
    private final Settings settings;
    private final Environment environment;
    private final PluginsService pluginsService;
    private final Client client;

    public InternalNode() throws ElasticSearchException {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, true);
    }

    public InternalNode(Settings pSettings, boolean loadConfigSettings) throws ElasticSearchException {
        Tuple<Settings, Environment> tuple = InternalSettingsPerparer.prepareSettings(pSettings, loadConfigSettings);
        ESLogger logger = Loggers.getLogger(Node.class, tuple.v1().get("name"));
        logger.info("{{}}[{}]: initializing ...", Version.full(), JvmInfo.jvmInfo().pid());
        this.pluginsService = new PluginsService(tuple.v1(), tuple.v2());
        this.settings = this.pluginsService.updatedSettings();
        this.environment = tuple.v2();
        ModulesBuilder modules = new ModulesBuilder();
        modules.add((Module)new PluginsModule(this.settings, this.pluginsService));
        modules.add((Module)new SettingsModule(this.settings));
        modules.add((Module)new NodeModule(this));
        modules.add((Module)new NetworkModule());
        modules.add((Module)new NodeCacheModule(this.settings));
        modules.add((Module)new ScriptModule());
        modules.add((Module)new JmxModule(this.settings));
        modules.add((Module)new EnvironmentModule(this.environment));
        modules.add((Module)new NodeEnvironmentModule());
        modules.add((Module)new ClusterNameModule(this.settings));
        modules.add((Module)new ThreadPoolModule(this.settings));
        modules.add((Module)new DiscoveryModule(this.settings));
        modules.add((Module)new ClusterModule(this.settings));
        modules.add((Module)new RestModule(this.settings));
        modules.add((Module)new TransportModule(this.settings));
        if (this.settings.getAsBoolean("http.enabled", true).booleanValue()) {
            modules.add((Module)new HttpServerModule(this.settings));
        }
        modules.add((Module)new RiversModule(this.settings));
        modules.add((Module)new IndicesModule(this.settings));
        modules.add((Module)new SearchModule());
        modules.add((Module)new TransportActionModule());
        modules.add((Module)new MonitorModule(this.settings));
        modules.add((Module)new GatewayModule(this.settings));
        modules.add((Module)new NodeClientModule());
        this.injector = modules.createInjector();
        this.client = this.injector.getInstance(Client.class);
        logger.info("{{}}[{}]: initialized", Version.full(), JvmInfo.jvmInfo().pid());
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public Node start() {
        if (!this.lifecycle.moveToStarted()) {
            return this;
        }
        ESLogger logger = Loggers.getLogger(Node.class, this.settings.get("name"));
        logger.info("{{}}[{}]: starting ...", Version.full(), JvmInfo.jvmInfo().pid());
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.services()) {
            this.injector.getInstance(plugin).start();
        }
        this.injector.getInstance(IndicesService.class).start();
        this.injector.getInstance(IndicesClusterStateService.class).start();
        this.injector.getInstance(RiversManager.class).start();
        this.injector.getInstance(ClusterService.class).start();
        this.injector.getInstance(RoutingService.class).start();
        this.injector.getInstance(SearchService.class).start();
        this.injector.getInstance(MonitorService.class).start();
        this.injector.getInstance(RestController.class).start();
        this.injector.getInstance(TransportService.class).start();
        DiscoveryService discoService = (DiscoveryService)this.injector.getInstance(DiscoveryService.class).start();
        this.injector.getInstance(GatewayService.class).start();
        if (this.settings.getAsBoolean("http.enabled", true).booleanValue()) {
            this.injector.getInstance(HttpServer.class).start();
        }
        this.injector.getInstance(JmxService.class).connectAndRegister(discoService.nodeDescription(), this.injector.getInstance(NetworkService.class));
        logger.info("{{}}[{}]: started", Version.full(), JvmInfo.jvmInfo().pid());
        return this;
    }

    @Override
    public Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        ESLogger logger = Loggers.getLogger(Node.class, this.settings.get("name"));
        logger.info("{{}}[{}]: stopping ...", Version.full(), JvmInfo.jvmInfo().pid());
        if (this.settings.getAsBoolean("http.enabled", true).booleanValue()) {
            this.injector.getInstance(HttpServer.class).stop();
        }
        this.injector.getInstance(IndicesClusterStateService.class).stop();
        this.injector.getInstance(IndicesService.class).stop();
        this.injector.getInstance(RoutingService.class).stop();
        this.injector.getInstance(ClusterService.class).stop();
        this.injector.getInstance(DiscoveryService.class).stop();
        this.injector.getInstance(MonitorService.class).stop();
        this.injector.getInstance(GatewayService.class).stop();
        this.injector.getInstance(SearchService.class).stop();
        this.injector.getInstance(RiversManager.class).stop();
        this.injector.getInstance(RestController.class).stop();
        this.injector.getInstance(TransportService.class).stop();
        this.injector.getInstance(JmxService.class).close();
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.services()) {
            this.injector.getInstance(plugin).stop();
        }
        logger.info("{{}}[{}]: stopped", Version.full(), JvmInfo.jvmInfo().pid());
        return this;
    }

    @Override
    public void close() {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.moveToClosed()) {
            return;
        }
        ESLogger logger = Loggers.getLogger(Node.class, this.settings.get("name"));
        logger.info("{{}}[{}]: closing ...", Version.full(), JvmInfo.jvmInfo().pid());
        StopWatch stopWatch = new StopWatch("node_close");
        stopWatch.start("http");
        if (this.settings.getAsBoolean("http.enabled", true).booleanValue()) {
            this.injector.getInstance(HttpServer.class).close();
        }
        stopWatch.stop().start("client");
        this.injector.getInstance(Client.class).close();
        stopWatch.stop().start("indices_cluster");
        this.injector.getInstance(IndicesClusterStateService.class).close();
        stopWatch.stop().start("indices");
        this.injector.getInstance(IndicesService.class).close();
        stopWatch.stop().start("routing");
        this.injector.getInstance(RoutingService.class).close();
        stopWatch.stop().start("cluster");
        this.injector.getInstance(ClusterService.class).close();
        stopWatch.stop().start("discovery");
        this.injector.getInstance(DiscoveryService.class).close();
        stopWatch.stop().start("monitor");
        this.injector.getInstance(MonitorService.class).close();
        stopWatch.stop().start("gateway");
        this.injector.getInstance(GatewayService.class).close();
        stopWatch.stop().start("search");
        this.injector.getInstance(SearchService.class).close();
        stopWatch.stop().start("indexers");
        this.injector.getInstance(RiversManager.class).close();
        stopWatch.stop().start("rest");
        this.injector.getInstance(RestController.class).close();
        stopWatch.stop().start("transport");
        this.injector.getInstance(TransportService.class).close();
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.services()) {
            stopWatch.stop().start("plugin(" + plugin.getName() + ")");
            this.injector.getInstance(plugin).close();
        }
        stopWatch.stop().start("node_cache");
        this.injector.getInstance(NodeCache.class).close();
        stopWatch.stop().start("script");
        this.injector.getInstance(ScriptService.class).close();
        stopWatch.stop().start("thread_pool");
        this.injector.getInstance(ThreadPool.class).shutdown();
        try {
            this.injector.getInstance(ThreadPool.class).awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        stopWatch.stop().start("thread_pool_force_shutdown");
        try {
            this.injector.getInstance(ThreadPool.class).shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        stopWatch.stop();
        ThreadLocals.clearReferencesThreadLocals();
        if (logger.isTraceEnabled()) {
            logger.trace("Close times for each service:\n{}", stopWatch.prettyPrint());
        }
        this.injector.getInstance(NodeEnvironment.class).close();
        Injectors.close(this.injector);
        logger.info("{{}}[{}]: closed", Version.full(), JvmInfo.jvmInfo().pid());
    }

    public Injector injector() {
        return this.injector;
    }

    public static void main(String[] args) throws Exception {
        final InternalNode node = new InternalNode();
        node.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                node.close();
            }
        });
    }
}

