/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.plugins.Plugin;

public class PluginsService
extends AbstractComponent {
    private final Environment environment;
    private final ImmutableMap<String, Plugin> plugins;

    @Inject
    public PluginsService(Settings settings, Environment environment) {
        super(settings);
        this.environment = environment;
        this.loadPluginsIntoClassLoader();
        HashMap<String, Plugin> plugins = Maps.newHashMap();
        plugins.putAll(this.loadPluginsFromClasspath(settings));
        this.logger.info("loaded {}", plugins.keySet());
        this.plugins = ImmutableMap.copyOf(plugins);
    }

    public ImmutableMap<String, Plugin> plugins() {
        return this.plugins;
    }

    public void processModules(Iterable<Module> modules) {
        for (Module module : modules) {
            this.processModule(module);
        }
    }

    public void processModule(Module module) {
        for (Plugin plugin : this.plugins().values()) {
            plugin.processModule(module);
        }
    }

    public Settings updatedSettings() {
        return this.settings;
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList<Class<? extends Module>> modules = Lists.newArrayList();
        for (Plugin plugin : this.plugins.values()) {
            modules.addAll(plugin.modules());
        }
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList<Class<? extends LifecycleComponent>> services = Lists.newArrayList();
        for (Plugin plugin : this.plugins.values()) {
            services.addAll(plugin.services());
        }
        return services;
    }

    public Collection<Class<? extends Module>> indexModules() {
        ArrayList<Class<? extends Module>> modules = Lists.newArrayList();
        for (Plugin plugin : this.plugins.values()) {
            modules.addAll(plugin.indexModules());
        }
        return modules;
    }

    public Collection<Class<? extends CloseableIndexComponent>> indexServices() {
        ArrayList<Class<? extends CloseableIndexComponent>> services = Lists.newArrayList();
        for (Plugin plugin : this.plugins.values()) {
            services.addAll(plugin.indexServices());
        }
        return services;
    }

    public Collection<Class<? extends Module>> shardModules() {
        ArrayList<Class<? extends Module>> modules = Lists.newArrayList();
        for (Plugin plugin : this.plugins.values()) {
            modules.addAll(plugin.shardModules());
        }
        return modules;
    }

    public Collection<Class<? extends CloseableIndexComponent>> shardServices() {
        ArrayList<Class<? extends CloseableIndexComponent>> services = Lists.newArrayList();
        for (Plugin plugin : this.plugins.values()) {
            services.addAll(plugin.shardServices());
        }
        return services;
    }

    private void loadPluginsIntoClassLoader() {
        File[] pluginsFiles;
        File pluginsFile = this.environment.pluginsFile();
        if (!pluginsFile.exists()) {
            return;
        }
        if (!pluginsFile.isDirectory()) {
            return;
        }
        ClassLoader classLoader = this.settings.getClassLoader();
        Class<?> classLoaderClass = classLoader.getClass();
        Method addURL = null;
        while (!classLoaderClass.equals(Object.class)) {
            try {
                addURL = classLoaderClass.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                break;
            }
            catch (NoSuchMethodException e) {
                classLoaderClass = classLoaderClass.getSuperclass();
            }
        }
        if (addURL == null) {
            this.logger.debug("failed to find addURL method on classLoader [" + classLoader + "] to add methods", new Object[0]);
            return;
        }
        for (File pluginFile : pluginsFiles = pluginsFile.listFiles()) {
            if (!pluginFile.isDirectory()) continue;
            this.logger.trace("--- adding plugin [" + pluginFile.getAbsolutePath() + "]", new Object[0]);
            try {
                addURL.invoke((Object)classLoader, pluginFile.toURI().toURL());
                for (File jarToAdd : pluginFile.listFiles()) {
                    if (!jarToAdd.getName().endsWith(".jar") && !jarToAdd.getName().endsWith(".zip")) continue;
                    addURL.invoke((Object)classLoader, jarToAdd.toURI().toURL());
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to add plugin [" + pluginFile + "]", e, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Plugin> loadPluginsFromClasspath(Settings settings) {
        HashMap<String, Plugin> plugins = Maps.newHashMap();
        Enumeration<URL> pluginUrls = null;
        try {
            pluginUrls = settings.getClassLoader().getResources("es-plugin.properties");
        }
        catch (IOException e) {
            this.logger.warn("failed to find plugins from classpath", e, new Object[0]);
            return ImmutableMap.of();
        }
        while (pluginUrls.hasMoreElements()) {
            URL pluginUrl = pluginUrls.nextElement();
            Properties pluginProps = new Properties();
            InputStream is = null;
            try {
                Plugin plugin;
                is = pluginUrl.openStream();
                pluginProps.load(is);
                String sPluginClass = pluginProps.getProperty("plugin");
                Class<?> pluginClass = settings.getClassLoader().loadClass(sPluginClass);
                try {
                    plugin = (Plugin)pluginClass.getConstructor(Settings.class).newInstance(settings);
                }
                catch (NoSuchMethodException e) {
                    try {
                        plugin = (Plugin)pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        throw new ElasticSearchException("No constructor for [" + pluginClass + "]");
                    }
                }
                plugins.put(plugin.name(), plugin);
            }
            catch (Exception e) {
                this.logger.warn("failed to load plugin from [" + pluginUrl + "]", e, new Object[0]);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return plugins;
    }
}

