/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Utf8RestResponse;

public class StringRestResponse
extends Utf8RestResponse {
    private static ThreadLocal<ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>> cache = new ThreadLocal<ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>>(){

        @Override
        protected ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result> initialValue() {
            return new ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>(new UnicodeUtil.UTF8Result());
        }
    };

    public StringRestResponse(RestStatus status) {
        super(status);
    }

    public StringRestResponse(RestStatus status, String content) {
        super(status, StringRestResponse.convert(content));
    }

    private static UnicodeUtil.UTF8Result convert(String content) {
        UnicodeUtil.UTF8Result result = cache.get().get();
        UnicodeUtil.UTF16toUTF8((String)content, (int)0, (int)content.length(), (UnicodeUtil.UTF8Result)result);
        return result;
    }
}

