/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.ping.replication;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.ping.replication.IndexReplicationPingResponse;
import org.elasticsearch.action.admin.cluster.ping.replication.ReplicationPingRequest;
import org.elasticsearch.action.admin.cluster.ping.replication.ReplicationPingResponse;
import org.elasticsearch.action.admin.cluster.ping.replication.ShardReplicationPingRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestReplicationPingAction
extends BaseRestHandler {
    @Inject
    public RestReplicationPingAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_ping/replication", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/{index}/_ping/replication", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        ReplicationPingRequest replicationPingRequest = new ReplicationPingRequest(RestActions.splitIndices(request.param("index")));
        replicationPingRequest.timeout(request.paramAsTime("timeout", ShardReplicationPingRequest.DEFAULT_TIMEOUT));
        replicationPingRequest.listenerThreaded(false);
        String replicationType = request.param("replication");
        if (replicationType != null) {
            replicationPingRequest.replicationType(ReplicationType.fromString(replicationType));
        }
        this.client.admin().cluster().ping(replicationPingRequest, new ActionListener<ReplicationPingResponse>(){

            @Override
            public void onResponse(ReplicationPingResponse result) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("ok", true);
                    for (IndexReplicationPingResponse indexResponse : result.indices().values()) {
                        builder.startObject(indexResponse.index()).field("ok", true).startObject("_shards").field("total", indexResponse.totalShards()).field("successful", indexResponse.successfulShards()).field("failed", indexResponse.failedShards()).endObject().endObject();
                    }
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestReplicationPingAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

