/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.status;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.status.GatewayRecoveryStatus;
import org.elasticsearch.action.admin.indices.status.GatewaySnapshotStatus;
import org.elasticsearch.action.admin.indices.status.IndexShardStatus;
import org.elasticsearch.action.admin.indices.status.IndexStatus;
import org.elasticsearch.action.admin.indices.status.IndicesStatusRequest;
import org.elasticsearch.action.admin.indices.status.IndicesStatusResponse;
import org.elasticsearch.action.admin.indices.status.PeerRecoveryStatus;
import org.elasticsearch.action.admin.indices.status.ShardStatus;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestIndicesStatusAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestIndicesStatusAction(Settings settings, Client client, RestController controller, SettingsFilter settingsFilter) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_status", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_status", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        IndicesStatusRequest indicesStatusRequest = new IndicesStatusRequest(RestActions.splitIndices(request.param("index")));
        indicesStatusRequest.listenerThreaded(false);
        BroadcastOperationThreading operationThreading = BroadcastOperationThreading.fromString(request.param("operation_threading"), BroadcastOperationThreading.SINGLE_THREAD);
        if (operationThreading == BroadcastOperationThreading.NO_THREADS) {
            operationThreading = BroadcastOperationThreading.SINGLE_THREAD;
        }
        indicesStatusRequest.operationThreading(operationThreading);
        this.client.admin().indices().status(indicesStatusRequest, new ActionListener<IndicesStatusResponse>(){

            @Override
            public void onResponse(IndicesStatusResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("ok", true);
                    RestActions.buildBroadcastShardsHeader(builder, response);
                    builder.startObject("indices");
                    for (IndexStatus indexStatus : response.indices().values()) {
                        builder.startObject(indexStatus.index(), XContentBuilder.FieldCaseConversion.NONE);
                        builder.array("aliases", indexStatus.settings().getAsArray("index.aliases"));
                        builder.startObject("settings");
                        Settings settings = RestIndicesStatusAction.this.settingsFilter.filterSettings(indexStatus.settings());
                        for (Map.Entry entry : settings.getAsMap().entrySet()) {
                            builder.field((String)entry.getKey(), (String)entry.getValue());
                        }
                        builder.endObject();
                        builder.startObject("index");
                        if (indexStatus.storeSize() != null) {
                            builder.field("primary_size", indexStatus.primaryStoreSize().toString());
                            builder.field("primary_size_in_bytes", indexStatus.primaryStoreSize().bytes());
                            builder.field("size", indexStatus.storeSize().toString());
                            builder.field("size_in_bytes", indexStatus.storeSize().bytes());
                        }
                        builder.endObject();
                        if (indexStatus.translogOperations() != -1L) {
                            builder.startObject("translog");
                            builder.field("operations", indexStatus.translogOperations());
                            builder.endObject();
                        }
                        if (indexStatus.docs() != null) {
                            builder.startObject("docs");
                            builder.field("num_docs", indexStatus.docs().numDocs());
                            builder.field("max_doc", indexStatus.docs().maxDoc());
                            builder.field("deleted_docs", indexStatus.docs().deletedDocs());
                            builder.endObject();
                        }
                        builder.startObject("shards");
                        for (IndexShardStatus indexShardStatus : indexStatus) {
                            builder.startArray(Integer.toString(indexShardStatus.shardId().id()));
                            for (ShardStatus shardStatus : indexShardStatus) {
                                builder.startObject();
                                builder.startObject("routing").field("state", (Object)shardStatus.shardRouting().state()).field("primary", shardStatus.shardRouting().primary()).field("node", shardStatus.shardRouting().currentNodeId()).field("relocating_node", shardStatus.shardRouting().relocatingNodeId()).field("shard", shardStatus.shardRouting().shardId().id()).field("index", shardStatus.shardRouting().shardId().index().name()).endObject();
                                builder.field("state", (Object)shardStatus.state());
                                if (shardStatus.storeSize() != null) {
                                    builder.startObject("index");
                                    builder.field("size", shardStatus.storeSize().toString());
                                    builder.field("size_in_bytes", shardStatus.storeSize().bytes());
                                    builder.endObject();
                                }
                                if (shardStatus.translogId() != -1L) {
                                    builder.startObject("translog");
                                    builder.field("id", shardStatus.translogId());
                                    builder.field("operations", shardStatus.translogOperations());
                                    builder.endObject();
                                }
                                if (shardStatus.docs() != null) {
                                    builder.startObject("docs");
                                    builder.field("num_docs", shardStatus.docs().numDocs());
                                    builder.field("max_doc", shardStatus.docs().maxDoc());
                                    builder.field("deleted_docs", shardStatus.docs().deletedDocs());
                                    builder.endObject();
                                }
                                if (shardStatus.peerRecoveryStatus() != null) {
                                    PeerRecoveryStatus peerRecoveryStatus = shardStatus.peerRecoveryStatus();
                                    builder.startObject("peer_recovery");
                                    builder.field("stage", (Object)peerRecoveryStatus.stage());
                                    builder.field("start_time_in_millis", peerRecoveryStatus.startTime());
                                    builder.field("time", (Object)peerRecoveryStatus.time());
                                    builder.field("time_in_millis", peerRecoveryStatus.time().millis());
                                    builder.startObject("index");
                                    builder.field("progress", peerRecoveryStatus.indexRecoveryProgress());
                                    builder.field("size", (Object)peerRecoveryStatus.indexSize());
                                    builder.field("size_in_bytes", peerRecoveryStatus.indexSize().bytes());
                                    builder.field("reused_size", (Object)peerRecoveryStatus.reusedIndexSize());
                                    builder.field("reused_size_in_bytes", peerRecoveryStatus.reusedIndexSize().bytes());
                                    builder.field("expected_recovered_size", (Object)peerRecoveryStatus.expectedRecoveredIndexSize());
                                    builder.field("expected_recovered_size_in_bytes", peerRecoveryStatus.expectedRecoveredIndexSize().bytes());
                                    builder.field("recovered_size", (Object)peerRecoveryStatus.recoveredIndexSize());
                                    builder.field("recovered_size_in_bytes", peerRecoveryStatus.recoveredIndexSize().bytes());
                                    builder.endObject();
                                    builder.startObject("translog");
                                    builder.field("recovered", peerRecoveryStatus.recoveredTranslogOperations());
                                    builder.endObject();
                                    builder.endObject();
                                }
                                if (shardStatus.gatewayRecoveryStatus() != null) {
                                    GatewayRecoveryStatus gatewayRecoveryStatus = shardStatus.gatewayRecoveryStatus();
                                    builder.startObject("gateway_recovery");
                                    builder.field("stage", (Object)gatewayRecoveryStatus.stage());
                                    builder.field("start_time_in_millis", gatewayRecoveryStatus.startTime());
                                    builder.field("time", (Object)gatewayRecoveryStatus.time());
                                    builder.field("time_in_millis", gatewayRecoveryStatus.time().millis());
                                    builder.startObject("index");
                                    builder.field("progress", gatewayRecoveryStatus.indexRecoveryProgress());
                                    builder.field("size", (Object)gatewayRecoveryStatus.indexSize());
                                    builder.field("size_in_bytes", gatewayRecoveryStatus.indexSize().bytes());
                                    builder.field("reused_size", (Object)gatewayRecoveryStatus.reusedIndexSize());
                                    builder.field("reused_size_in_bytes", gatewayRecoveryStatus.reusedIndexSize().bytes());
                                    builder.field("expected_recovered_size", (Object)gatewayRecoveryStatus.expectedRecoveredIndexSize());
                                    builder.field("expected_recovered_size_in_bytes", gatewayRecoveryStatus.expectedRecoveredIndexSize().bytes());
                                    builder.field("recovered_size", (Object)gatewayRecoveryStatus.recoveredIndexSize());
                                    builder.field("recovered_size_in_bytes", gatewayRecoveryStatus.recoveredIndexSize().bytes());
                                    builder.endObject();
                                    builder.startObject("translog");
                                    builder.field("recovered", gatewayRecoveryStatus.recoveredTranslogOperations());
                                    builder.endObject();
                                    builder.endObject();
                                }
                                if (shardStatus.gatewaySnapshotStatus() != null) {
                                    GatewaySnapshotStatus gatewaySnapshotStatus = shardStatus.gatewaySnapshotStatus();
                                    builder.startObject("gateway_snapshot");
                                    builder.field("stage", (Object)gatewaySnapshotStatus.stage());
                                    builder.field("start_time_in_millis", gatewaySnapshotStatus.startTime());
                                    builder.field("time", (Object)gatewaySnapshotStatus.time());
                                    builder.field("time_in_millis", gatewaySnapshotStatus.time().millis());
                                    builder.startObject("index");
                                    builder.field("size", (Object)gatewaySnapshotStatus.indexSize());
                                    builder.field("size_in_bytes", gatewaySnapshotStatus.indexSize().bytes());
                                    builder.endObject();
                                    builder.startObject("index");
                                    builder.field("expected_operations", gatewaySnapshotStatus.expectedNumberOfOperations());
                                    builder.endObject();
                                    builder.endObject();
                                }
                                builder.endObject();
                            }
                            builder.endArray();
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endObject();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestIndicesStatusAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

