/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.mvel.MvelScriptEngineService;

public class ScriptModule
extends AbstractModule {
    private List<Class<? extends ScriptEngineService>> scriptEngines = Lists.newArrayList();

    public void addScriptEngine(Class<? extends ScriptEngineService> scriptEngine) {
        this.scriptEngines.add(scriptEngine);
    }

    @Override
    protected void configure() {
        Multibinder<ScriptEngineService> multibinder = Multibinder.newSetBinder(this.binder(), ScriptEngineService.class);
        try {
            multibinder.addBinding().to(MvelScriptEngineService.class);
        }
        catch (Throwable t) {
            // empty catch block
        }
        for (Class<? extends ScriptEngineService> scriptEngine : this.scriptEngines) {
            multibinder.addBinding().to(scriptEngine);
        }
        this.bind(ScriptService.class).asEagerSingleton();
    }
}

