/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.CachedDfSource;
import org.elasticsearch.search.dfs.DfsPhase;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.InternalSearchRequest;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchService
extends AbstractLifecycleComponent<SearchService> {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final DfsPhase dfsPhase;
    private final QueryPhase queryPhase;
    private final FetchPhase fetchPhase;
    private final long defaultKeepAlive;
    private final ScheduledFuture keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final CleanContextOnIndicesLifecycleListener indicesLifecycleListener = new CleanContextOnIndicesLifecycleListener();
    private final ConcurrentMapLong<SearchContext> activeContexts = ConcurrentCollections.newConcurrentMapLong();
    private final ImmutableMap<String, SearchParseElement> elementParsers;
    private static final int[] EMPTY_DOC_IDS = new int[0];

    @Inject
    public SearchService(Settings settings, ClusterService clusterService, IndicesService indicesService, IndicesLifecycle indicesLifecycle, ThreadPool threadPool, ScriptService scriptService, DfsPhase dfsPhase, QueryPhase queryPhase, FetchPhase fetchPhase) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.dfsPhase = dfsPhase;
        this.queryPhase = queryPhase;
        this.fetchPhase = fetchPhase;
        TimeValue keepAliveInterval = this.componentSettings.getAsTime("keep_alive_interval", TimeValue.timeValueMinutes(1L));
        this.defaultKeepAlive = this.componentSettings.getAsTime("default_keep_alive", TimeValue.timeValueMinutes(5L)).millis();
        HashMap<String, ? extends SearchParseElement> elementParsers = new HashMap<String, SearchParseElement>();
        elementParsers.putAll(dfsPhase.parseElements());
        elementParsers.putAll(queryPhase.parseElements());
        elementParsers.putAll(fetchPhase.parseElements());
        this.elementParsers = ImmutableMap.copyOf(elementParsers);
        indicesLifecycle.addListener(this.indicesLifecycleListener);
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay(new Reaper(), keepAliveInterval);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        for (SearchContext context : this.activeContexts.values()) {
            this.freeContext(context);
        }
        this.activeContexts.clear();
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.keepAliveReaper.cancel(false);
        this.indicesService.indicesLifecycle().removeListener(this.indicesLifecycleListener);
    }

    public void releaseContextsForIndex(Index index) {
        for (SearchContext context : this.activeContexts.values()) {
            if (!context.shardTarget().index().equals(index.name())) continue;
            this.freeContext(context);
        }
    }

    public void releaseContextsForShard(ShardId shardId) {
        for (SearchContext context : this.activeContexts.values()) {
            if (!context.shardTarget().index().equals(shardId.index().name()) || context.shardTarget().shardId() != shardId.id()) continue;
            this.freeContext(context);
        }
    }

    public DfsSearchResult executeDfsPhase(InternalSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.createContext(request);
        this.activeContexts.put(context.id(), context);
        try {
            this.contextProcessing(context);
            this.dfsPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            DfsSearchResult dfsSearchResult = context.dfsResult();
            return dfsSearchResult;
        }
        catch (RuntimeException e) {
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeQueryPhase(InternalSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.createContext(request);
        this.activeContexts.put(context.id(), context);
        try {
            this.contextProcessing(context);
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (RuntimeException e) {
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQuerySearchResult executeQueryPhase(InternalScrollSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        try {
            this.contextProcessing(context);
            this.processScroll(request, context);
            this.contextProcessedSuccessfully(context);
            this.queryPhase.execute(context);
            ScrollQuerySearchResult scrollQuerySearchResult = new ScrollQuerySearchResult(context.queryResult(), context.shardTarget());
            return scrollQuerySearchResult;
        }
        catch (RuntimeException e) {
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeQueryPhase(QuerySearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            context.searcher().dfSource(new CachedDfSource(request.dfs(), context.similarityService().defaultSearchSimilarity()));
        }
        catch (IOException e) {
            this.freeContext(context);
            this.cleanContext(context);
            throw new QueryPhaseExecutionException(context, "Failed to set aggregated df", (Throwable)e);
        }
        try {
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            QuerySearchResult e = context.queryResult();
            return e;
        }
        catch (RuntimeException e) {
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QueryFetchSearchResult executeFetchPhase(InternalSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.createContext(request);
        this.activeContexts.put(context.id(), context);
        this.contextProcessing(context);
        try {
            this.queryPhase.execute(context);
            this.shortcutDocIdsToLoad(context);
            this.fetchPhase.execute(context);
            if (context.scroll() == null) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            QueryFetchSearchResult queryFetchSearchResult = new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
            return queryFetchSearchResult;
        }
        catch (RuntimeException e) {
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QueryFetchSearchResult executeFetchPhase(QuerySearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            context.searcher().dfSource(new CachedDfSource(request.dfs(), context.similarityService().defaultSearchSimilarity()));
        }
        catch (IOException e) {
            this.freeContext(context);
            this.cleanContext(context);
            throw new QueryPhaseExecutionException(context, "Failed to set aggregated df", (Throwable)e);
        }
        try {
            this.queryPhase.execute(context);
            this.shortcutDocIdsToLoad(context);
            this.fetchPhase.execute(context);
            if (context.scroll() == null) {
                this.freeContext(request.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            QueryFetchSearchResult e = new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
            return e;
        }
        catch (RuntimeException e) {
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQueryFetchSearchResult executeFetchPhase(InternalScrollSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            this.processScroll(request, context);
            this.queryPhase.execute(context);
            this.shortcutDocIdsToLoad(context);
            this.fetchPhase.execute(context);
            if (context.scroll() == null) {
                this.freeContext(request.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(new QueryFetchSearchResult(context.queryResult(), context.fetchResult()), context.shardTarget());
            return scrollQueryFetchSearchResult;
        }
        catch (RuntimeException e) {
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public FetchSearchResult executeFetchPhase(FetchSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            context.docIdsToLoad(request.docIds(), 0, request.docIdsSize());
            this.fetchPhase.execute(context);
            if (context.scroll() == null) {
                this.freeContext(request.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            FetchSearchResult fetchSearchResult = context.fetchResult();
            return fetchSearchResult;
        }
        catch (RuntimeException e) {
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    private SearchContext findContext(long id) throws SearchContextMissingException {
        SearchContext context = this.activeContexts.get(id);
        if (context == null) {
            throw new SearchContextMissingException(id);
        }
        SearchContext.setCurrent(context);
        return context;
    }

    private SearchContext createContext(InternalSearchRequest request) throws ElasticSearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(request.shardId());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().id(), request.index(), request.shardId());
        Engine.Searcher engineSearcher = indexShard.searcher();
        SearchContext context = new SearchContext(this.idGenerator.incrementAndGet(), shardTarget, request.numberOfShards(), request.timeout(), request.types(), engineSearcher, indexService, this.scriptService);
        SearchContext.setCurrent(context);
        try {
            context.scroll(request.scroll());
            this.parseSource(context, request.source(), request.sourceOffset(), request.sourceLength());
            this.parseSource(context, request.extraSource(), request.extraSourceOffset(), request.extraSourceLength());
            if (context.from() == -1) {
                context.from(0);
            }
            if (context.size() == -1) {
                context.size(10);
            }
            this.dfsPhase.preProcess(context);
            this.queryPhase.preProcess(context);
            this.fetchPhase.preProcess(context);
            long keepAlive = this.defaultKeepAlive;
            if (request.scroll() != null && request.scroll().keepAlive() != null) {
                keepAlive = request.scroll().keepAlive().millis();
            }
            context.keepAlive(keepAlive);
        }
        catch (RuntimeException e) {
            context.release();
            throw e;
        }
        return context;
    }

    public void freeContext(long id) {
        SearchContext context = this.activeContexts.remove(id);
        if (context == null) {
            return;
        }
        this.freeContext(context);
    }

    private void freeContext(SearchContext context) {
        this.activeContexts.remove(context.id());
        context.release();
    }

    private void contextProcessing(SearchContext context) {
        context.accessed(-1L);
    }

    private void contextProcessedSuccessfully(SearchContext context) {
        context.accessed(System.currentTimeMillis());
    }

    private void cleanContext(SearchContext context) {
        SearchContext.removeCurrent();
    }

    private void parseSource(SearchContext context, byte[] source, int offset, int length) throws SearchParseException {
        if (source == null || length == 0) {
            return;
        }
        try {
            XContentParser.Token token;
            XContentParser parser = XContentFactory.xContent(source, offset, length).createParser(source, offset, length);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    SearchParseElement element = this.elementParsers.get(fieldName);
                    if (element == null) {
                        throw new SearchParseException(context, "No parser for element [" + fieldName + "]");
                    }
                    element.parse(parser, context);
                    continue;
                }
                if (token != null) continue;
            }
            parser.close();
        }
        catch (Exception e) {
            String sSource = "_na_";
            try {
                sSource = Unicode.fromBytes(source, offset, length);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw new SearchParseException(context, "Failed to parse source [" + sSource + "]", (Throwable)e);
        }
    }

    private void shortcutDocIdsToLoad(SearchContext context) {
        TopDocs topDocs = context.queryResult().topDocs();
        if (topDocs.scoreDocs.length < context.from()) {
            context.docIdsToLoad(EMPTY_DOC_IDS, 0, 0);
            return;
        }
        int totalSize = context.from() + context.size();
        int[] docIdsToLoad = new int[context.size()];
        int counter = 0;
        for (int i = context.from(); i < totalSize && i < topDocs.scoreDocs.length; ++i) {
            docIdsToLoad[counter] = topDocs.scoreDocs[i].doc;
            ++counter;
        }
        context.docIdsToLoad(docIdsToLoad, 0, counter);
    }

    private void processScroll(InternalScrollSearchRequest request, SearchContext context) {
        context.from(context.from() + context.size());
        context.scroll(request.scroll());
        if (request.scroll() != null && request.scroll().keepAlive() != null) {
            context.keepAlive(request.scroll().keepAlive().millis());
        }
    }

    class Reaper
    implements Runnable {
        Reaper() {
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            for (SearchContext context : SearchService.this.activeContexts.values()) {
                if (context.lastAccessTime() == -1L || time - context.lastAccessTime() <= context.keepAlive()) continue;
                SearchService.this.freeContext(context);
            }
        }
    }

    class CleanContextOnIndicesLifecycleListener
    extends IndicesLifecycle.Listener {
        CleanContextOnIndicesLifecycleListener() {
        }

        @Override
        public void beforeIndexClosed(IndexService indexService, boolean delete) {
            SearchService.this.releaseContextsForIndex(indexService.index());
        }

        @Override
        public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, boolean delete) {
            SearchService.this.releaseContextsForShard(shardId);
        }
    }
}

