/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.facet.FacetProcessor;

public class FacetProcessors {
    private final ImmutableMap<String, FacetProcessor> processors;

    @Inject
    public FacetProcessors(Set<FacetProcessor> processors) {
        MapBuilder<String, FacetProcessor> builder = MapBuilder.newMapBuilder();
        for (FacetProcessor processor : processors) {
            for (String type : processor.types()) {
                builder.put(type, processor);
            }
        }
        this.processors = builder.immutableMap();
    }

    public FacetProcessor processor(String type) {
        return this.processors.get(type);
    }
}

