/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.util.Comparator;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.search.facet.Facet;

public interface DateHistogramFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "date_histogram";

    public List<? extends Entry> entries();

    public List<? extends Entry> getEntries();

    public static interface Entry {
        public long time();

        public long getTime();

        public long count();

        public long getCount();

        public double total();

        public double getTotal();

        public double mean();

        public double getMean();
    }

    public static enum ComparatorType {
        TIME(0, "time", new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.time() < o2.time() ? -1 : (o1.time() == o2.time() ? 0 : 1);
            }
        }),
        COUNT(1, "count", new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.count() < o2.count() ? -1 : (o1.count() == o2.count() ? 0 : 1);
            }
        }),
        TOTAL(2, "total", new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.total() < o2.total() ? -1 : (o1.total() == o2.total() ? 0 : 1);
            }
        });

        private final byte id;
        private final String description;
        private final Comparator<Entry> comparator;

        private ComparatorType(byte id, String description, Comparator<Entry> comparator) {
            this.id = id;
            this.description = description;
            this.comparator = comparator;
        }

        public byte id() {
            return this.id;
        }

        public String description() {
            return this.description;
        }

        public Comparator<Entry> comparator() {
            return this.comparator;
        }

        public static ComparatorType fromId(byte id) {
            if (id == 0) {
                return TIME;
            }
            if (id == 1) {
                return COUNT;
            }
            if (id == 2) {
                return TOTAL;
            }
            throw new ElasticSearchIllegalArgumentException("No type argument match for histogram comparator [" + id + "]");
        }

        public static ComparatorType fromString(String type) {
            if ("time".equals(type)) {
                return TIME;
            }
            if ("count".equals(type)) {
                return COUNT;
            }
            if ("total".equals(type)) {
                return TOTAL;
            }
            throw new ElasticSearchIllegalArgumentException("No type argument match for histogram comparator [" + type + "]");
        }
    }
}

