/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.trove.map.hash.TLongDoubleHashMap;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.field.data.longs.LongFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.datehistogram.CountDateHistogramFacetCollector;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalCountAndTotalDateHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ValueDateHistogramFacetCollector
extends AbstractFacetCollector {
    private final String keyIndexFieldName;
    private final String valueIndexFieldName;
    private MutableDateTime dateTime;
    private final long interval;
    private final DateHistogramFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType keyFieldDataType;
    private LongFieldData keyFieldData;
    private final FieldDataType valueFieldDataType;
    private NumericFieldData valueFieldData;
    private final TLongLongHashMap counts = new TLongLongHashMap();
    private final TLongDoubleHashMap totals = new TLongDoubleHashMap();

    public ValueDateHistogramFacetCollector(String facetName, String keyFieldName, String valueFieldName, MutableDateTime dateTime, long interval, DateHistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.dateTime = dateTime;
        this.interval = interval;
        this.comparatorType = comparatorType;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(keyFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + keyFieldName + "]");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.keyIndexFieldName = smartMappers.mapper().names().indexName();
        this.keyFieldDataType = smartMappers.mapper().fieldDataType();
        FieldMapper mapper = context.mapperService().smartNameFieldMapper(valueFieldName);
        if (mapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for value_field [" + valueFieldName + "]");
        }
        this.valueIndexFieldName = mapper.names().indexName();
        this.valueFieldDataType = mapper.fieldDataType();
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.keyFieldData.date(doc, this.dateTime);
        long time = this.dateTime.getMillis();
        if (this.interval != 1L) {
            time = CountDateHistogramFacetCollector.bucket(time, this.interval);
        }
        if (this.valueFieldData.multiValued()) {
            for (double value : this.valueFieldData.doubleValues(doc)) {
                this.counts.adjustOrPutValue(time, 1L, 1L);
                this.totals.adjustOrPutValue(time, value, value);
            }
        } else {
            double value = this.valueFieldData.doubleValue(doc);
            this.counts.adjustOrPutValue(time, 1L, 1L);
            this.totals.adjustOrPutValue(time, value, value);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyFieldData = (LongFieldData)this.fieldDataCache.cache(this.keyFieldDataType, reader, this.keyIndexFieldName);
        this.valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.valueIndexFieldName);
    }

    @Override
    public Facet facet() {
        return new InternalCountAndTotalDateHistogramFacet(this.facetName, this.comparatorType, this.counts, this.totals);
    }
}

