/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.filter;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.XContentFilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;

public class FilterFacetBuilder
extends AbstractFacetBuilder {
    private XContentFilterBuilder filter;

    public FilterFacetBuilder(String name) {
        super(name);
    }

    @Override
    public FilterFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public FilterFacetBuilder scope(String scope) {
        super.scope(scope);
        return this;
    }

    @Override
    public FilterFacetBuilder facetFilter(XContentFilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    public FilterFacetBuilder filter(XContentFilterBuilder filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.filter == null) {
            throw new SearchSourceBuilderException("filter must be set on filter facet for facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.field("filter");
        this.filter.toXContent(builder, params);
        this.addFilterFacetAndGlobal(builder, params);
        builder.endObject();
        return builder;
    }
}

