/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPoint;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptGeoDistanceFacetCollector
extends GeoDistanceFacetCollector {
    private final SearchScript script;

    public ScriptGeoDistanceFacetCollector(String facetName, String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries, SearchContext context, String scriptLang, String script, Map<String, Object> params) {
        super(facetName, fieldName, lat, lon, unit, geoDistance, entries, context);
        this.script = context.scriptService().search(context.lookup(), scriptLang, script, params);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.script.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        super.doSetNextReader(reader, docBase);
        this.script.setNextReader(reader);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        if (!this.fieldData.hasValue(doc)) {
            return;
        }
        this.script.setNextDocId(doc);
        double value = this.script.runAsDouble();
        if (this.fieldData.multiValued()) {
            GeoPoint[] points;
            for (GeoPoint point : points = this.fieldData.values(doc)) {
                double distance = this.geoDistance.calculate(this.lat, this.lon, point.lat(), point.lon(), this.unit);
                for (GeoDistanceFacet.Entry entry : this.entries) {
                    if (!(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                    ++entry.count;
                    entry.total += value;
                }
            }
        } else {
            GeoPoint point = this.fieldData.value(doc);
            double distance = this.geoDistance.calculate(this.lat, this.lon, point.lat(), point.lon(), this.unit);
            for (GeoDistanceFacet.Entry entry : this.entries) {
                if (!(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                ++entry.count;
                entry.total += value;
            }
        }
    }
}

