/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.xcontent.geo.GeoPoint;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetCollector;
import org.elasticsearch.search.facet.geodistance.InternalGeoDistanceFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ValueGeoDistanceFacetCollector
extends GeoDistanceFacetCollector {
    private final String indexValueFieldName;
    private final FieldDataType valueFieldDataType;
    private NumericFieldData valueFieldData;

    public ValueGeoDistanceFacetCollector(String facetName, String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries, SearchContext context, String valueFieldName) {
        super(facetName, fieldName, lat, lon, unit, geoDistance, entries, context);
        FieldMapper mapper = context.mapperService().smartNameFieldMapper(valueFieldName);
        if (mapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + valueFieldName + "]");
        }
        this.indexValueFieldName = valueFieldName;
        this.valueFieldDataType = mapper.fieldDataType();
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        super.doSetNextReader(reader, docBase);
        this.valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.indexValueFieldName);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        if (!this.fieldData.hasValue(doc)) {
            return;
        }
        if (this.fieldData.multiValued()) {
            GeoPoint[] points = this.fieldData.values(doc);
            double[] values = this.valueFieldData.multiValued() ? this.valueFieldData.doubleValues(doc) : null;
            for (int i = 0; i < points.length; ++i) {
                double distance = this.geoDistance.calculate(this.lat, this.lon, points[i].lat(), points[i].lon(), this.unit);
                for (GeoDistanceFacet.Entry entry : this.entries) {
                    if (!(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                    ++entry.count;
                    if (values != null) {
                        if (i >= values.length) continue;
                        entry.total += values[i];
                        continue;
                    }
                    if (!this.valueFieldData.hasValue(doc)) continue;
                    entry.total += this.valueFieldData.doubleValue(doc);
                }
            }
        } else {
            GeoPoint point = this.fieldData.value(doc);
            double distance = this.geoDistance.calculate(this.lat, this.lon, point.lat(), point.lon(), this.unit);
            for (GeoDistanceFacet.Entry entry : this.entries) {
                if (!(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                ++entry.count;
                if (this.valueFieldData.multiValued()) {
                    double[] values;
                    for (double value : values = this.valueFieldData.doubleValues(doc)) {
                        entry.total += value;
                    }
                    continue;
                }
                if (!this.valueFieldData.hasValue(doc)) continue;
                entry.total += this.valueFieldData.doubleValue(doc);
            }
        }
    }

    @Override
    public Facet facet() {
        return new InternalGeoDistanceFacet(this.facetName, this.entries);
    }
}

