/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.histogram.CountAndTotalHistogramFacetCollector;
import org.elasticsearch.search.facet.histogram.CountHistogramFacetCollector;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalHistogramFacet;
import org.elasticsearch.search.facet.histogram.KeyValueHistogramFacetCollector;
import org.elasticsearch.search.facet.histogram.KeyValueScriptHistogramFacetCollector;
import org.elasticsearch.search.facet.histogram.ScriptHistogramFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class HistogramFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    @Inject
    public HistogramFacetProcessor(Settings settings) {
        super(settings);
        InternalHistogramFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"histogram"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String keyField = null;
        String valueField = null;
        String keyScript = null;
        String valueScript = null;
        String scriptLang = null;
        Map<String, Object> params = null;
        long interval = 0L;
        HistogramFacet.ComparatorType comparatorType = HistogramFacet.ComparatorType.KEY;
        String fieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(fieldName)) continue;
                params = parser.map();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("key_field".equals(fieldName) || "keyField".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("value_field".equals(fieldName) || "valueField".equals(fieldName)) {
                valueField = parser.text();
                continue;
            }
            if ("interval".equals(fieldName)) {
                interval = parser.longValue();
                continue;
            }
            if ("time_interval".equals(fieldName)) {
                interval = TimeValue.parseTimeValue(parser.text(), null).millis();
                continue;
            }
            if ("key_script".equals(fieldName) || "keyScript".equals(fieldName)) {
                keyScript = parser.text();
                continue;
            }
            if ("value_script".equals(fieldName) || "valueScript".equals(fieldName)) {
                valueScript = parser.text();
                continue;
            }
            if ("order".equals(fieldName) || "comparator".equals(fieldName)) {
                comparatorType = HistogramFacet.ComparatorType.fromString(parser.text());
                continue;
            }
            if (!"lang".equals(fieldName)) continue;
            scriptLang = parser.text();
        }
        if (keyScript != null && valueScript != null) {
            return new ScriptHistogramFacetCollector(facetName, scriptLang, keyScript, valueScript, params, interval, comparatorType, context);
        }
        if (keyField == null) {
            throw new FacetPhaseExecutionException(facetName, "key field is required to be set for histogram facet, either using [field] or using [key_field]");
        }
        if (interval <= 0L) {
            throw new FacetPhaseExecutionException(facetName, "[interval] is required to be set for histogram facet");
        }
        if (valueScript != null) {
            return new KeyValueScriptHistogramFacetCollector(facetName, keyField, scriptLang, valueScript, params, interval, comparatorType, context);
        }
        if (valueField == null) {
            return new CountHistogramFacetCollector(facetName, keyField, interval, comparatorType, context);
        }
        if (keyField.equals(valueField)) {
            return new CountAndTotalHistogramFacetCollector(facetName, keyField, interval, comparatorType, context);
        }
        return new KeyValueHistogramFacetCollector(facetName, keyField, valueField, interval, comparatorType, context);
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        InternalHistogramFacet first = (InternalHistogramFacet)facets.get(0);
        return first.reduce(name, facets);
    }
}

