/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.trove.iterator.TLongLongIterator;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalHistogramFacet;

public class InternalCountHistogramFacet
extends InternalHistogramFacet {
    private static final String STREAM_TYPE = "cHistogram";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalCountHistogramFacet.readHistogramFacet(in);
        }
    };
    private String name;
    HistogramFacet.ComparatorType comparatorType;
    TLongLongHashMap counts;
    CountEntry[] entries = null;
    static final TLongLongHashMap EMPTY_LONG_LONG_MAP = new TLongLongHashMap();

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalCountHistogramFacet() {
    }

    public InternalCountHistogramFacet(String name, HistogramFacet.ComparatorType comparatorType, TLongLongHashMap counts) {
        this.name = name;
        this.comparatorType = comparatorType;
        this.counts = counts;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return "histogram";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<CountEntry> entries() {
        return Arrays.asList(this.computeEntries());
    }

    public List<CountEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<HistogramFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    private CountEntry[] computeEntries() {
        if (this.entries != null) {
            return this.entries;
        }
        this.entries = new CountEntry[this.counts.size()];
        int i = 0;
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            this.entries[i++] = new CountEntry(it.key(), it.value());
        }
        Arrays.sort(this.entries, this.comparatorType.comparator());
        return this.entries;
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        TLongLongHashMap counts = null;
        InternalCountHistogramFacet firstHistoFacet = (InternalCountHistogramFacet)facets.get(0);
        for (Facet facet : facets) {
            InternalCountHistogramFacet histoFacet = (InternalCountHistogramFacet)facet;
            if (histoFacet.counts.isEmpty()) continue;
            if (counts == null) {
                counts = histoFacet.counts;
                continue;
            }
            TLongLongIterator it = histoFacet.counts.iterator();
            while (it.hasNext()) {
                it.advance();
                counts.adjustOrPutValue(it.key(), it.value(), it.value());
            }
        }
        if (counts == null) {
            counts = EMPTY_LONG_LONG_MAP;
        }
        firstHistoFacet.counts = counts;
        return firstHistoFacet;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "histogram");
        builder.startArray(Fields.ENTRIES);
        for (CountEntry entry : this.computeEntries()) {
            builder.startObject();
            builder.field(Fields.KEY, entry.key());
            builder.field(Fields.COUNT, entry.count());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalCountHistogramFacet readHistogramFacet(StreamInput in) throws IOException {
        InternalCountHistogramFacet facet = new InternalCountHistogramFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = HistogramFacet.ComparatorType.fromId(in.readByte());
        int size = in.readVInt();
        if (size == 0) {
            this.counts = EMPTY_LONG_LONG_MAP;
        } else {
            this.counts = new TLongLongHashMap(size);
            for (int i = 0; i < size; ++i) {
                long key = in.readLong();
                this.counts.put(key, in.readVLong());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.counts.size());
        TLongLongIterator it = this.counts.iterator();
        while (it.hasNext()) {
            it.advance();
            out.writeLong(it.key());
            out.writeVLong(it.value());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString ENTRIES = new XContentBuilderString("entries");
        static final XContentBuilderString KEY = new XContentBuilderString("key");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public class CountEntry
    implements HistogramFacet.Entry {
        private final long key;
        private final long count;

        public CountEntry(long key, long count) {
            this.key = key;
            this.count = count;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public long getKey() {
            return this.key();
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public long getCount() {
            return this.count();
        }

        @Override
        public double total() {
            return -1.0;
        }

        @Override
        public double getTotal() {
            return this.total();
        }

        @Override
        public double mean() {
            return -1.0;
        }

        @Override
        public double getMean() {
            return this.mean();
        }
    }
}

