/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.trove.map.hash.TLongDoubleHashMap;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.InternalCountAndTotalHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptHistogramFacetCollector
extends AbstractFacetCollector {
    private final SearchScript keyScript;
    private final SearchScript valueScript;
    private final long interval;
    private final HistogramFacet.ComparatorType comparatorType;
    private final TLongLongHashMap counts = new TLongLongHashMap();
    private final TLongDoubleHashMap totals = new TLongDoubleHashMap();

    public ScriptHistogramFacetCollector(String facetName, String scriptLang, String keyScript, String valueScript, Map<String, Object> params, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.keyScript = context.scriptService().search(context.lookup(), scriptLang, keyScript, params);
        this.valueScript = context.scriptService().search(context.lookup(), scriptLang, valueScript, params);
        this.interval = interval > 0L ? interval : 0L;
        this.comparatorType = comparatorType;
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.keyScript.setNextDocId(doc);
        this.valueScript.setNextDocId(doc);
        long bucket = this.interval == 0L ? this.keyScript.runAsLong() : ScriptHistogramFacetCollector.bucket(this.keyScript.runAsDouble(), this.interval);
        double value = this.valueScript.runAsDouble();
        this.counts.adjustOrPutValue(bucket, 1L, 1L);
        this.totals.adjustOrPutValue(bucket, value, value);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.keyScript.setScorer(scorer);
        this.valueScript.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyScript.setNextReader(reader);
        this.valueScript.setNextReader(reader);
    }

    @Override
    public Facet facet() {
        return new InternalCountAndTotalHistogramFacet(this.facetName, this.comparatorType, this.counts, this.totals);
    }

    public static long bucket(double value, long interval) {
        return (long)(value / (double)interval) * interval;
    }
}

