/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.range.RangeFacet;

public class InternalRangeFacet
implements RangeFacet,
InternalFacet {
    private static final String STREAM_TYPE = "range";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalRangeFacet.readRangeFacet(in);
        }
    };
    private String name;
    RangeFacet.Entry[] entries;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    InternalRangeFacet() {
    }

    public InternalRangeFacet(String name, RangeFacet.Entry[] entries) {
        this.name = name;
        this.entries = entries;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return STREAM_TYPE;
    }

    @Override
    public String getType() {
        return STREAM_TYPE;
    }

    @Override
    public List<RangeFacet.Entry> entries() {
        return ImmutableList.copyOf(this.entries);
    }

    @Override
    public List<RangeFacet.Entry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<RangeFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    public static InternalRangeFacet readRangeFacet(StreamInput in) throws IOException {
        InternalRangeFacet facet = new InternalRangeFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.entries = new RangeFacet.Entry[in.readVInt()];
        for (int i = 0; i < this.entries.length; ++i) {
            RangeFacet.Entry entry = new RangeFacet.Entry();
            entry.from = in.readDouble();
            entry.to = in.readDouble();
            if (in.readBoolean()) {
                entry.fromAsString = in.readUTF();
            }
            if (in.readBoolean()) {
                entry.toAsString = in.readUTF();
            }
            entry.count = in.readVLong();
            entry.total = in.readDouble();
            this.entries[i] = entry;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeVInt(this.entries.length);
        for (RangeFacet.Entry entry : this.entries) {
            out.writeDouble(entry.from);
            out.writeDouble(entry.to);
            if (entry.fromAsString == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(entry.fromAsString);
            }
            if (entry.toAsString == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(entry.toAsString);
            }
            out.writeVLong(entry.count);
            out.writeDouble(entry.total);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, STREAM_TYPE);
        builder.startArray(Fields.RANGES);
        for (RangeFacet.Entry entry : this.entries) {
            builder.startObject();
            if (!Double.isInfinite(entry.from)) {
                builder.field(Fields.FROM, entry.from);
            }
            if (entry.fromAsString != null) {
                builder.field(Fields.FROM_STR, entry.fromAsString);
            }
            if (!Double.isInfinite(entry.to)) {
                builder.field(Fields.TO, entry.to);
            }
            if (entry.toAsString != null) {
                builder.field(Fields.TO_STR, entry.toAsString);
            }
            builder.field(Fields.COUNT, entry.count());
            builder.field(Fields.TOTAL, entry.total());
            builder.field(Fields.MEAN, entry.mean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString RANGES = new XContentBuilderString("ranges");
        static final XContentBuilderString FROM = new XContentBuilderString("from");
        static final XContentBuilderString FROM_STR = new XContentBuilderString("from_str");
        static final XContentBuilderString TO = new XContentBuilderString("to");
        static final XContentBuilderString TO_STR = new XContentBuilderString("to_str");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");

        Fields() {
        }
    }
}

