/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.range.InternalRangeFacet;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.internal.SearchContext;

public class KeyValueRangeFacetCollector
extends AbstractFacetCollector {
    private final String keyIndexFieldName;
    private final String valueIndexFieldName;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType keyFieldDataType;
    private NumericFieldData keyFieldData;
    private final FieldDataType valueFieldDataType;
    private NumericFieldData valueFieldData;
    private final RangeFacet.Entry[] entries;

    public KeyValueRangeFacetCollector(String facetName, String keyFieldName, String valueFieldName, RangeFacet.Entry[] entries, SearchContext context) {
        super(facetName);
        this.entries = entries;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(keyFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + keyFieldName + "]");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.keyIndexFieldName = smartMappers.mapper().names().indexName();
        this.keyFieldDataType = smartMappers.mapper().fieldDataType();
        FieldMapper mapper = context.mapperService().smartNameFieldMapper(valueFieldName);
        if (mapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for value_field [" + valueFieldName + "]");
        }
        this.valueIndexFieldName = mapper.names().indexName();
        this.valueFieldDataType = mapper.fieldDataType();
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyFieldData = (NumericFieldData)this.fieldDataCache.cache(this.keyFieldDataType, reader, this.keyIndexFieldName);
        this.valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.valueIndexFieldName);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        if (this.keyFieldData.multiValued()) {
            if (this.valueFieldData.multiValued()) {
                double[] keys = this.keyFieldData.doubleValues(doc);
                double[] values = this.valueFieldData.doubleValues(doc);
                int size = Math.min(keys.length, values.length);
                for (int i = 0; i < size; ++i) {
                    double key = keys[i];
                    for (RangeFacet.Entry entry : this.entries) {
                        if (!(key >= entry.getFrom()) || !(key < entry.getTo())) continue;
                        ++entry.count;
                        entry.total += values[i];
                    }
                }
            } else {
                double value = this.valueFieldData.doubleValue(doc);
                for (double key : this.keyFieldData.doubleValues(doc)) {
                    for (RangeFacet.Entry entry : this.entries) {
                        if (!(key >= entry.getFrom()) || !(key < entry.getTo())) continue;
                        ++entry.count;
                        entry.total += value;
                    }
                }
            }
        } else {
            double key = this.keyFieldData.doubleValue(doc);
            if (this.valueFieldData.multiValued()) {
                for (RangeFacet.Entry entry : this.entries) {
                    if (!(key >= entry.getFrom()) || !(key < entry.getTo())) continue;
                    ++entry.count;
                    for (double value : this.valueFieldData.doubleValues(doc)) {
                        entry.total += value;
                    }
                }
            } else {
                double value = this.valueFieldData.doubleValue(doc);
                for (RangeFacet.Entry entry : this.entries) {
                    if (!(key >= entry.getFrom()) || !(key < entry.getTo())) continue;
                    ++entry.count;
                    entry.total += value;
                }
            }
        }
    }

    @Override
    public Facet facet() {
        return new InternalRangeFacet(this.facetName, this.entries);
    }
}

