/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.doubles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.common.trove.iterator.TDoubleIntIterator;
import org.elasticsearch.common.trove.map.hash.TDoubleIntHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;

public class InternalDoubleTermsFacet
extends InternalTermsFacet {
    private static final String STREAM_TYPE = "dTerms";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalDoubleTermsFacet.readTermsFacet(in);
        }
    };
    private String name;
    int requiredSize;
    long missing;
    Collection<DoubleEntry> entries = ImmutableList.of();
    TermsFacet.ComparatorType comparatorType;
    private static ThreadLocal<ThreadLocals.CleanableValue<TDoubleIntHashMap>> aggregateCache = new ThreadLocal<ThreadLocals.CleanableValue<TDoubleIntHashMap>>(){

        @Override
        protected ThreadLocals.CleanableValue<TDoubleIntHashMap> initialValue() {
            return new ThreadLocals.CleanableValue<TDoubleIntHashMap>(new TDoubleIntHashMap());
        }
    };

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    InternalDoubleTermsFacet() {
    }

    public InternalDoubleTermsFacet(String name, TermsFacet.ComparatorType comparatorType, int requiredSize, Collection<DoubleEntry> entries, long missing) {
        this.name = name;
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries;
        this.missing = missing;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String type() {
        return "terms";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<DoubleEntry> entries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    public List<DoubleEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<TermsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long missingCount() {
        return this.missing;
    }

    @Override
    public long getMissingCount() {
        return this.missingCount();
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        InternalDoubleTermsFacet first = (InternalDoubleTermsFacet)facets.get(0);
        TDoubleIntHashMap aggregated = aggregateCache.get().get();
        aggregated.clear();
        long missing = 0L;
        for (Facet facet : facets) {
            InternalDoubleTermsFacet mFacet = (InternalDoubleTermsFacet)facet;
            missing += mFacet.missingCount();
            for (DoubleEntry entry : mFacet.entries) {
                aggregated.adjustOrPutValue(entry.term, entry.count(), entry.count());
            }
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(first.comparatorType.comparator(), first.requiredSize);
        TDoubleIntIterator it = aggregated.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new DoubleEntry(it.key(), it.value()));
        }
        first.entries = ordered;
        first.missing = missing;
        return first;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "terms");
        builder.field(Fields.MISSING, this.missing);
        builder.startArray(Fields.TERMS);
        for (DoubleEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, entry.term);
            builder.field(Fields.COUNT, entry.count());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalDoubleTermsFacet readTermsFacet(StreamInput in) throws IOException {
        InternalDoubleTermsFacet facet = new InternalDoubleTermsFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = TermsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        int size = in.readVInt();
        this.entries = new ArrayList<DoubleEntry>(size);
        for (int i = 0; i < size; ++i) {
            this.entries.add(new DoubleEntry(in.readDouble(), in.readVInt()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVInt(this.entries.size());
        for (DoubleEntry entry : this.entries) {
            out.writeDouble(entry.term);
            out.writeVInt(entry.count());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class DoubleEntry
    implements TermsFacet.Entry {
        double term;
        int count;

        public DoubleEntry(double term, int count) {
            this.term = term;
            this.count = count;
        }

        @Override
        public String term() {
            return Double.toString(this.term);
        }

        @Override
        public String getTerm() {
            return this.term();
        }

        @Override
        public Number termAsNumber() {
            return this.term;
        }

        @Override
        public Number getTermAsNumber() {
            return this.termAsNumber();
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public int getCount() {
            return this.count();
        }

        @Override
        public int compareTo(TermsFacet.Entry o) {
            double anotherVal = ((DoubleEntry)o).term;
            if (this.term < anotherVal) {
                return -1;
            }
            if (this.term == anotherVal) {
                int i = this.count - o.count();
                if (i == 0) {
                    i = System.identityHashCode(this) - System.identityHashCode(o);
                }
                return i;
            }
            return 1;
        }
    }
}

