/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.ints;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.common.trove.iterator.TIntIntIterator;
import org.elasticsearch.common.trove.map.hash.TIntIntHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.ints.IntFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.ints.InternalIntTermsFacet;
import org.elasticsearch.search.internal.SearchContext;

public class TermsIntFacetCollector
extends AbstractFacetCollector {
    static ThreadLocal<ThreadLocals.CleanableValue<Deque<TIntIntHashMap>>> cache = new ThreadLocal<ThreadLocals.CleanableValue<Deque<TIntIntHashMap>>>(){

        @Override
        protected ThreadLocals.CleanableValue<Deque<TIntIntHashMap>> initialValue() {
            return new ThreadLocals.CleanableValue<Deque<TIntIntHashMap>>(new ArrayDeque());
        }
    };
    private final FieldDataCache fieldDataCache;
    private final String indexFieldName;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final FieldDataType fieldDataType;
    private IntFieldData fieldData;
    private final StaticAggregatorValueProc aggregator;
    private final SearchScript script;

    public TermsIntFacetCollector(String facetName, String fieldName, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, String scriptLang, String script, Map<String, Object> params) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.size = size;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] doesn't have a type, can't run terms int facet collector on it");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        if (smartMappers.mapper().fieldDataType() != FieldDataType.DefaultTypes.INT) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] is not of int type, can't run terms int facet collector on it");
        }
        this.indexFieldName = smartMappers.mapper().names().indexName();
        this.fieldDataType = smartMappers.mapper().fieldDataType();
        this.script = script != null ? context.scriptService().search(context.lookup(), scriptLang, script, params) : null;
        this.aggregator = this.script == null ? new StaticAggregatorValueProc(TermsIntFacetCollector.popFacets()) : new AggregatorValueProc(TermsIntFacetCollector.popFacets(), this.script);
        if (allTerms) {
            try {
                for (IndexReader reader : context.searcher().subReaders()) {
                    IntFieldData fieldData = (IntFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
                    fieldData.forEachValue(this.aggregator);
                }
            }
            catch (Exception e) {
                throw new FacetPhaseExecutionException(facetName, "failed to load all terms", e);
            }
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (this.script != null) {
            this.script.setScorer(scorer);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (IntFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        if (this.script != null) {
            this.script.setNextReader(reader);
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.aggregator);
    }

    @Override
    public Facet facet() {
        TIntIntHashMap facets = this.aggregator.facets();
        if (facets.isEmpty()) {
            TermsIntFacetCollector.pushFacets(facets);
            return new InternalIntTermsFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalIntTermsFacet.IntEntry>of(), this.aggregator.missing());
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size * this.numberOfShards);
        TIntIntIterator it = facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalIntTermsFacet.IntEntry(it.key(), it.value()));
        }
        TermsIntFacetCollector.pushFacets(facets);
        return new InternalIntTermsFacet(this.facetName, this.comparatorType, this.size, ordered, this.aggregator.missing());
    }

    static TIntIntHashMap popFacets() {
        Deque<TIntIntHashMap> deque = cache.get().get();
        if (deque.isEmpty()) {
            deque.add(new TIntIntHashMap());
        }
        TIntIntHashMap facets = deque.pollFirst();
        facets.clear();
        return facets;
    }

    static void pushFacets(TIntIntHashMap facets) {
        facets.clear();
        Deque<TIntIntHashMap> deque = cache.get().get();
        if (deque != null) {
            deque.add(facets);
        }
    }

    public static class StaticAggregatorValueProc
    implements IntFieldData.ValueInDocProc,
    IntFieldData.ValueProc {
        private final TIntIntHashMap facets;
        private int missing;

        public StaticAggregatorValueProc(TIntIntHashMap facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(int value) {
            this.facets.putIfAbsent(value, 0);
        }

        @Override
        public void onValue(int docId, int value) {
            this.facets.adjustOrPutValue(value, 1, 1);
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public final TIntIntHashMap facets() {
            return this.facets;
        }

        public final int missing() {
            return this.missing;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final SearchScript script;

        public AggregatorValueProc(TIntIntHashMap facets, SearchScript script) {
            super(facets);
            this.script = script;
        }

        @Override
        public void onValue(int docId, int value) {
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = ((Number)scriptValue).intValue();
                }
            }
            super.onValue(docId, value);
        }
    }
}

