/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.ip;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.common.trove.iterator.TLongIntIterator;
import org.elasticsearch.common.trove.map.hash.TLongIntHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.longs.LongFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.ip.InternalIpTermsFacet;
import org.elasticsearch.search.internal.SearchContext;

public class TermsIpFacetCollector
extends AbstractFacetCollector {
    static ThreadLocal<ThreadLocals.CleanableValue<Deque<TLongIntHashMap>>> cache = new ThreadLocal<ThreadLocals.CleanableValue<Deque<TLongIntHashMap>>>(){

        @Override
        protected ThreadLocals.CleanableValue<Deque<TLongIntHashMap>> initialValue() {
            return new ThreadLocals.CleanableValue<Deque<TLongIntHashMap>>(new ArrayDeque());
        }
    };
    private final FieldDataCache fieldDataCache;
    private final String indexFieldName;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final FieldDataType fieldDataType;
    private LongFieldData fieldData;
    private final StaticAggregatorValueProc aggregator;
    private final SearchScript script;

    public TermsIpFacetCollector(String facetName, String fieldName, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, String scriptLang, String script, Map<String, Object> params) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.size = size;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] doesn't have a type, can't run terms long facet collector on it");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        if (smartMappers.mapper().fieldDataType() != FieldDataType.DefaultTypes.LONG) {
            throw new ElasticSearchIllegalArgumentException("Field [" + fieldName + "] is not of long type, can't run terms long facet collector on it");
        }
        this.indexFieldName = smartMappers.mapper().names().indexName();
        this.fieldDataType = smartMappers.mapper().fieldDataType();
        this.script = script != null ? context.scriptService().search(context.lookup(), scriptLang, script, params) : null;
        this.aggregator = this.script == null ? new StaticAggregatorValueProc(TermsIpFacetCollector.popFacets()) : new AggregatorValueProc(TermsIpFacetCollector.popFacets(), this.script);
        if (allTerms) {
            try {
                for (IndexReader reader : context.searcher().subReaders()) {
                    LongFieldData fieldData = (LongFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
                    fieldData.forEachValue(this.aggregator);
                }
            }
            catch (Exception e) {
                throw new FacetPhaseExecutionException(facetName, "failed to load all terms", e);
            }
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (this.script != null) {
            this.script.setScorer(scorer);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (LongFieldData)this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        if (this.script != null) {
            this.script.setNextReader(reader);
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.aggregator);
    }

    @Override
    public Facet facet() {
        TLongIntHashMap facets = this.aggregator.facets();
        if (facets.isEmpty()) {
            TermsIpFacetCollector.pushFacets(facets);
            return new InternalIpTermsFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalIpTermsFacet.LongEntry>of(), this.aggregator.missing());
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size * this.numberOfShards);
        TLongIntIterator it = facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalIpTermsFacet.LongEntry(it.key(), it.value()));
        }
        TermsIpFacetCollector.pushFacets(facets);
        return new InternalIpTermsFacet(this.facetName, this.comparatorType, this.size, ordered, this.aggregator.missing());
    }

    static TLongIntHashMap popFacets() {
        Deque<TLongIntHashMap> deque = cache.get().get();
        if (deque.isEmpty()) {
            deque.add(new TLongIntHashMap());
        }
        TLongIntHashMap facets = deque.pollFirst();
        facets.clear();
        return facets;
    }

    static void pushFacets(TLongIntHashMap facets) {
        facets.clear();
        Deque<TLongIntHashMap> deque = cache.get().get();
        if (deque != null) {
            deque.add(facets);
        }
    }

    public static class StaticAggregatorValueProc
    implements LongFieldData.ValueInDocProc,
    LongFieldData.ValueProc {
        private final TLongIntHashMap facets;
        private int missing;

        public StaticAggregatorValueProc(TLongIntHashMap facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(long value) {
            this.facets.putIfAbsent(value, 0);
        }

        @Override
        public void onValue(int docId, long value) {
            this.facets.adjustOrPutValue(value, 1, 1);
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public final TLongIntHashMap facets() {
            return this.facets;
        }

        public final int missing() {
            return this.missing;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final SearchScript script;

        public AggregatorValueProc(TLongIntHashMap facets, SearchScript script) {
            super(facets);
            this.script = script;
        }

        @Override
        public void onValue(int docId, long value) {
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = ((Number)scriptValue).longValue();
                }
            }
            super.onValue(docId, value);
        }
    }
}

