/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.shorts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.common.trove.iterator.TShortIntIterator;
import org.elasticsearch.common.trove.map.hash.TShortIntHashMap;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.InternalTermsFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;

public class InternalShortTermsFacet
extends InternalTermsFacet {
    private static final String STREAM_TYPE = "sTerms";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalShortTermsFacet.readTermsFacet(in);
        }
    };
    private String name;
    int requiredSize;
    long missing;
    Collection<ShortEntry> entries = ImmutableList.of();
    TermsFacet.ComparatorType comparatorType;
    private static ThreadLocal<ThreadLocals.CleanableValue<TShortIntHashMap>> aggregateCache = new ThreadLocal<ThreadLocals.CleanableValue<TShortIntHashMap>>(){

        @Override
        protected ThreadLocals.CleanableValue<TShortIntHashMap> initialValue() {
            return new ThreadLocals.CleanableValue<TShortIntHashMap>(new TShortIntHashMap());
        }
    };

    public static void registerStream() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    InternalShortTermsFacet() {
    }

    public InternalShortTermsFacet(String name, TermsFacet.ComparatorType comparatorType, int requiredSize, Collection<ShortEntry> entries, long missing) {
        this.name = name;
        this.comparatorType = comparatorType;
        this.requiredSize = requiredSize;
        this.entries = entries;
        this.missing = missing;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String type() {
        return "terms";
    }

    @Override
    public String getType() {
        return this.type();
    }

    public List<ShortEntry> entries() {
        if (!(this.entries instanceof List)) {
            this.entries = ImmutableList.copyOf(this.entries);
        }
        return (List)this.entries;
    }

    public List<ShortEntry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<TermsFacet.Entry> iterator() {
        return this.entries.iterator();
    }

    @Override
    public long missingCount() {
        return this.missing;
    }

    @Override
    public long getMissingCount() {
        return this.missingCount();
    }

    @Override
    public Facet reduce(String name, List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        InternalShortTermsFacet first = (InternalShortTermsFacet)facets.get(0);
        TShortIntHashMap aggregated = aggregateCache.get().get();
        aggregated.clear();
        long missing = 0L;
        for (Facet facet : facets) {
            InternalShortTermsFacet mFacet = (InternalShortTermsFacet)facet;
            missing += mFacet.missingCount();
            for (ShortEntry entry : mFacet.entries) {
                aggregated.adjustOrPutValue(entry.term, entry.count(), entry.count());
            }
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(first.comparatorType.comparator(), first.requiredSize);
        TShortIntIterator it = aggregated.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new ShortEntry(it.key(), it.value()));
        }
        first.entries = ordered;
        first.missing = missing;
        return first;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "terms");
        builder.field(Fields.MISSING, this.missing);
        builder.startArray(Fields.TERMS);
        for (ShortEntry entry : this.entries) {
            builder.startObject();
            builder.field(Fields.TERM, (int)entry.term);
            builder.field(Fields.COUNT, entry.count());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static InternalShortTermsFacet readTermsFacet(StreamInput in) throws IOException {
        InternalShortTermsFacet facet = new InternalShortTermsFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.comparatorType = TermsFacet.ComparatorType.fromId(in.readByte());
        this.requiredSize = in.readVInt();
        this.missing = in.readVLong();
        int size = in.readVInt();
        this.entries = new ArrayList<ShortEntry>(size);
        for (int i = 0; i < size; ++i) {
            this.entries.add(new ShortEntry(in.readShort(), in.readVInt()));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeByte(this.comparatorType.id());
        out.writeVInt(this.requiredSize);
        out.writeVLong(this.missing);
        out.writeVInt(this.entries.size());
        for (ShortEntry entry : this.entries) {
            out.writeShort(entry.term);
            out.writeVInt(entry.count());
        }
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString MISSING = new XContentBuilderString("missing");
        static final XContentBuilderString TERMS = new XContentBuilderString("terms");
        static final XContentBuilderString TERM = new XContentBuilderString("term");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }

    public static class ShortEntry
    implements TermsFacet.Entry {
        short term;
        int count;

        public ShortEntry(short term, int count) {
            this.term = term;
            this.count = count;
        }

        @Override
        public String term() {
            return Short.toString(this.term);
        }

        @Override
        public String getTerm() {
            return this.term();
        }

        @Override
        public Number termAsNumber() {
            return this.term;
        }

        @Override
        public Number getTermAsNumber() {
            return this.termAsNumber();
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public int getCount() {
            return this.count();
        }

        @Override
        public int compareTo(TermsFacet.Entry o) {
            short anotherVal = ((ShortEntry)o).term;
            int i = this.term - anotherVal;
            if (i == 0 && (i = this.count - o.count()) == 0) {
                i = System.identityHashCode(this) - System.identityHashCode(o);
            }
            return i;
        }
    }
}

