/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.thread.ThreadLocals;
import org.elasticsearch.common.trove.iterator.TObjectIntIterator;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStringFacetCollector
extends AbstractFacetCollector {
    static ThreadLocal<ThreadLocals.CleanableValue<Deque<TObjectIntHashMap<String>>>> cache = new ThreadLocal<ThreadLocals.CleanableValue<Deque<TObjectIntHashMap<String>>>>(){

        @Override
        protected ThreadLocals.CleanableValue<Deque<TObjectIntHashMap<String>>> initialValue() {
            return new ThreadLocals.CleanableValue<Deque<TObjectIntHashMap<String>>>(new ArrayDeque());
        }
    };
    private final FieldDataCache fieldDataCache;
    private final String indexFieldName;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int numberOfShards;
    private final FieldDataType fieldDataType;
    private FieldData fieldData;
    private final StaticAggregatorValueProc aggregator;
    private final SearchScript script;

    public TermsStringFacetCollector(String facetName, String fieldName, int size, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<String> excluded, Pattern pattern, String scriptLang, String script, Map<String, Object> params) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.size = size;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            this.indexFieldName = fieldName;
            this.fieldDataType = FieldDataType.DefaultTypes.STRING;
        } else {
            if (smartMappers.hasDocMapper()) {
                this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
            }
            this.indexFieldName = smartMappers.mapper().names().indexName();
            this.fieldDataType = smartMappers.mapper().fieldDataType();
        }
        this.script = script != null ? context.scriptService().search(context.lookup(), scriptLang, script, params) : null;
        this.aggregator = excluded.isEmpty() && pattern == null && this.script == null ? new StaticAggregatorValueProc(TermsStringFacetCollector.popFacets()) : new AggregatorValueProc(TermsStringFacetCollector.popFacets(), excluded, pattern, this.script);
        if (allTerms) {
            try {
                for (IndexReader reader : context.searcher().subReaders()) {
                    FieldData fieldData = this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
                    fieldData.forEachValue(this.aggregator);
                }
            }
            catch (Exception e) {
                throw new FacetPhaseExecutionException(facetName, "failed to load all terms", e);
            }
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (this.script != null) {
            this.script.setScorer(scorer);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = this.fieldDataCache.cache(this.fieldDataType, reader, this.indexFieldName);
        if (this.script != null) {
            this.script.setNextReader(reader);
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.fieldData.forEachValueInDoc(doc, this.aggregator);
    }

    @Override
    public Facet facet() {
        TObjectIntHashMap<String> facets = this.aggregator.facets();
        if (facets.isEmpty()) {
            TermsStringFacetCollector.pushFacets(facets);
            return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalStringTermsFacet.StringEntry>of(), this.aggregator.missing());
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.size * this.numberOfShards);
        TObjectIntIterator<String> it = facets.iterator();
        while (it.hasNext()) {
            it.advance();
            ordered.add(new InternalStringTermsFacet.StringEntry(it.key(), it.value()));
        }
        TermsStringFacetCollector.pushFacets(facets);
        return new InternalStringTermsFacet(this.facetName, this.comparatorType, this.size, ordered, this.aggregator.missing());
    }

    static TObjectIntHashMap<String> popFacets() {
        Deque<TObjectIntHashMap<String>> deque = cache.get().get();
        if (deque.isEmpty()) {
            deque.add(new TObjectIntHashMap());
        }
        TObjectIntHashMap<String> facets = deque.pollFirst();
        facets.clear();
        return facets;
    }

    static void pushFacets(TObjectIntHashMap<String> facets) {
        facets.clear();
        Deque<TObjectIntHashMap<String>> deque = cache.get().get();
        if (deque != null) {
            deque.add(facets);
        }
    }

    public static class StaticAggregatorValueProc
    implements FieldData.StringValueInDocProc,
    FieldData.StringValueProc {
        private final TObjectIntHashMap<String> facets;
        private int missing = 0;

        public StaticAggregatorValueProc(TObjectIntHashMap<String> facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(String value) {
            this.facets.putIfAbsent(value, 0);
        }

        @Override
        public void onValue(int docId, String value) {
            this.facets.adjustOrPutValue(value, 1, 1);
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public final TObjectIntHashMap<String> facets() {
            return this.facets;
        }

        public final int missing() {
            return this.missing;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final ImmutableSet<String> excluded;
        private final Matcher matcher;
        private final SearchScript script;

        public AggregatorValueProc(TObjectIntHashMap<String> facets, ImmutableSet<String> excluded, Pattern pattern, SearchScript script) {
            super(facets);
            this.excluded = excluded;
            this.matcher = pattern != null ? pattern.matcher("") : null;
            this.script = script;
        }

        @Override
        public void onValue(int docId, String value) {
            if (this.excluded != null && this.excluded.contains(value)) {
                return;
            }
            if (this.matcher != null && !this.matcher.reset(value).matches()) {
                return;
            }
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = scriptValue.toString();
                }
            }
            super.onValue(docId, value);
        }
    }
}

