/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.util.List;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.id.IdCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParser;
import org.elasticsearch.index.query.IndexQueryParserMissingException;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.query.QuerySearchResult;

public class SearchContext
implements Releasable {
    private static ThreadLocal<SearchContext> current = new ThreadLocal();
    private final long id;
    private final SearchShardTarget shardTarget;
    private final int numberOfShards;
    private final Engine.Searcher engineSearcher;
    private final ScriptService scriptService;
    private final IndexService indexService;
    private final ContextIndexSearcher searcher;
    private final DfsSearchResult dfsResult;
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;
    private final TimeValue timeout;
    private float queryBoost = 1.0f;
    private Scroll scroll;
    private boolean explain;
    private boolean version = false;
    private List<String> fieldNames;
    private int from = -1;
    private int size = -1;
    private String[] types;
    private Sort sort;
    private boolean trackScores = false;
    private String queryParserName;
    private ParsedQuery originalQuery;
    private Query query;
    private Filter filter;
    private int[] docIdsToLoad;
    private int docsIdsToLoadFrom;
    private int docsIdsToLoadSize;
    private SearchContextFacets facets;
    private SearchContextHighlight highlight;
    private ScriptFieldsContext scriptFields;
    private SearchLookup searchLookup;
    private boolean queryRewritten;
    private volatile long keepAlive;
    private volatile long lastAccessTime;

    public static void setCurrent(SearchContext value) {
        current.set(value);
    }

    public static void removeCurrent() {
        current.remove();
    }

    public static SearchContext current() {
        return current.get();
    }

    public SearchContext(long id, SearchShardTarget shardTarget, int numberOfShards, TimeValue timeout, String[] types, Engine.Searcher engineSearcher, IndexService indexService, ScriptService scriptService) {
        this.id = id;
        this.shardTarget = shardTarget;
        this.numberOfShards = numberOfShards;
        this.timeout = timeout;
        this.types = types;
        this.engineSearcher = engineSearcher;
        this.scriptService = scriptService;
        this.dfsResult = new DfsSearchResult(id, shardTarget);
        this.queryResult = new QuerySearchResult(id, shardTarget);
        this.fetchResult = new FetchSearchResult(id, shardTarget);
        this.indexService = indexService;
        this.searcher = new ContextIndexSearcher(this, engineSearcher);
    }

    @Override
    public boolean release() throws ElasticSearchException {
        if (this.parsedQuery() != null) {
            for (ScopePhase scopePhase : this.parsedQuery().scopePhases()) {
                scopePhase.clear();
            }
        }
        try {
            this.searcher.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.engineSearcher.release();
        return true;
    }

    public long id() {
        return this.id;
    }

    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public String[] types() {
        return this.types;
    }

    public float queryBoost() {
        return this.queryBoost;
    }

    public SearchContext queryBoost(float queryBoost) {
        this.queryBoost = queryBoost;
        return this;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchContext scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchContextFacets facets() {
        return this.facets;
    }

    public SearchContext facets(SearchContextFacets facets) {
        this.facets = facets;
        return this;
    }

    public SearchContextHighlight highlight() {
        return this.highlight;
    }

    public void highlight(SearchContextHighlight highlight) {
        this.highlight = highlight;
    }

    public boolean hasScriptFields() {
        return this.scriptFields != null;
    }

    public ScriptFieldsContext scriptFields() {
        if (this.scriptFields == null) {
            this.scriptFields = new ScriptFieldsContext();
        }
        return this.scriptFields;
    }

    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    public IndexQueryParser queryParser() throws IndexQueryParserMissingException {
        if (this.queryParserName != null) {
            IndexQueryParser queryParser = this.queryParserService().indexQueryParser(this.queryParserName);
            if (queryParser == null) {
                throw new IndexQueryParserMissingException(this.queryParserName);
            }
            return queryParser;
        }
        return this.queryParserService().defaultIndexQueryParser();
    }

    public MapperService mapperService() {
        return this.indexService.mapperService();
    }

    public AnalysisService analysisService() {
        return this.indexService.analysisService();
    }

    public IndexQueryParserService queryParserService() {
        return this.indexService.queryParserService();
    }

    public SimilarityService similarityService() {
        return this.indexService.similarityService();
    }

    public ScriptService scriptService() {
        return this.scriptService;
    }

    public FilterCache filterCache() {
        return this.indexService.cache().filter();
    }

    public FieldDataCache fieldDataCache() {
        return this.indexService.cache().fieldData();
    }

    public IdCache idCache() {
        return this.indexService.cache().idCache();
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public SearchContext sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public Sort sort() {
        return this.sort;
    }

    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public boolean trackScores() {
        return this.trackScores;
    }

    public SearchContext parsedFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Filter parsedFilter() {
        return this.filter;
    }

    public String queryParserName() {
        return this.queryParserName;
    }

    public SearchContext queryParserName(String queryParserName) {
        this.queryParserName = queryParserName;
        return this;
    }

    public SearchContext parsedQuery(ParsedQuery query) {
        this.queryRewritten = false;
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    public Query query() {
        return this.query;
    }

    public boolean queryRewritten() {
        return this.queryRewritten;
    }

    public SearchContext updateRewriteQuery(Query rewriteQuery) {
        this.query = rewriteQuery;
        this.queryRewritten = true;
        return this;
    }

    public int from() {
        return this.from;
    }

    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public SearchContext size(int size) {
        this.size = size;
        return this;
    }

    public boolean hasFieldNames() {
        return this.fieldNames != null;
    }

    public List<String> fieldNames() {
        if (this.fieldNames == null) {
            this.fieldNames = Lists.newArrayList();
        }
        return this.fieldNames;
    }

    public void emptyFieldNames() {
        this.fieldNames = ImmutableList.of();
    }

    public boolean explain() {
        return this.explain;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    public boolean version() {
        return this.version;
    }

    public void version(boolean version) {
        this.version = version;
    }

    public int[] docIdsToLoad() {
        return this.docIdsToLoad;
    }

    public int docIdsToLoadFrom() {
        return this.docsIdsToLoadFrom;
    }

    public int docIdsToLoadSize() {
        return this.docsIdsToLoadSize;
    }

    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadFrom, int docsIdsToLoadSize) {
        this.docIdsToLoad = docIdsToLoad;
        this.docsIdsToLoadFrom = docsIdsToLoadFrom;
        this.docsIdsToLoadSize = docsIdsToLoadSize;
        return this;
    }

    public void accessed(long accessTime) {
        this.lastAccessTime = accessTime;
    }

    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public long keepAlive() {
        return this.keepAlive;
    }

    public void keepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public SearchLookup lookup() {
        if (this.searchLookup == null) {
            this.searchLookup = new SearchLookup(this.mapperService(), this.fieldDataCache());
        }
        return this.searchLookup;
    }

    public DfsSearchResult dfsResult() {
        return this.dfsResult;
    }

    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }
}

