/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.compress.lzf.LZFDecoder;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.LZFStreamInput;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.SourceFieldSelector;

public class SourceLookup
implements Map {
    private IndexReader reader;
    private int docId = -1;
    private Map<String, Object> source;
    private static final Pattern dotPattern = Pattern.compile("\\.");

    public Map<String, Object> source() {
        return this.source;
    }

    private Map<String, Object> loadSourceIfNeeded() {
        if (this.source != null) {
            return this.source;
        }
        XContentParser parser = null;
        try {
            Document doc = this.reader.document(this.docId, (FieldSelector)SourceFieldSelector.INSTANCE);
            Fieldable sourceField = doc.getFieldable("_source");
            byte[] source = sourceField.getBinaryValue();
            if (LZFDecoder.isCompressed(source)) {
                BytesStreamInput siBytes = new BytesStreamInput(source);
                LZFStreamInput siLzf = CachedStreamInput.cachedLzf(siBytes);
                XContentType contentType = XContentFactory.xContentType(siLzf);
                siLzf.resetToBufferStart();
                parser = XContentFactory.xContent(contentType).createParser(siLzf);
                this.source = parser.map();
            } else {
                parser = XContentFactory.xContent(source).createParser(source);
                this.source = parser.map();
            }
        }
        catch (Exception e) {
            throw new ElasticSearchParseException("failed to parse / load source", e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
        return this.source;
    }

    public void setNextReader(IndexReader reader) {
        if (this.reader == reader) {
            return;
        }
        this.reader = reader;
        this.source = null;
        this.docId = -1;
    }

    public void setNextDocId(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.source = null;
    }

    public List<Object> getValues(String path) {
        ArrayList<Object> values = Lists.newArrayList();
        String[] pathElements = dotPattern.split(path);
        this.getValues(values, this.loadSourceIfNeeded(), pathElements, 0);
        return values;
    }

    private void getValues(List<Object> values, Map<String, Object> part, String[] pathElements, int index) {
        if (index == pathElements.length) {
            return;
        }
        String currentPath = pathElements[index];
        Object currentValue = part.get(currentPath);
        if (currentValue == null) {
            return;
        }
        if (currentValue instanceof Map) {
            this.getValues(values, (Map)currentValue, pathElements, index + 1);
        } else if (currentValue instanceof List) {
            this.getValues(values, (List)currentValue, pathElements, index + 1);
        } else {
            values.add(currentValue);
        }
    }

    private void getValues(List<Object> values, List<Object> part, String[] pathElements, int index) {
        for (Object value : part) {
            if (value == null) continue;
            if (value instanceof Map) {
                this.getValues(values, (Map)value, pathElements, index);
                continue;
            }
            if (value instanceof List) {
                this.getValues(values, (List)value, pathElements, index);
                continue;
            }
            values.add(value);
        }
    }

    public Object get(Object key) {
        return this.loadSourceIfNeeded().get(key);
    }

    @Override
    public int size() {
        return this.loadSourceIfNeeded().size();
    }

    @Override
    public boolean isEmpty() {
        return this.loadSourceIfNeeded().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.loadSourceIfNeeded().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.loadSourceIfNeeded().containsValue(value);
    }

    public Set keySet() {
        return this.loadSourceIfNeeded().keySet();
    }

    public Collection values() {
        return this.loadSourceIfNeeded().values();
    }

    public Set entrySet() {
        return this.loadSourceIfNeeded().entrySet();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

