/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.util.Map;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.facet.FacetPhase;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.FilterBinaryParseElement;
import org.elasticsearch.search.query.FilterParseElement;
import org.elasticsearch.search.query.FromParseElement;
import org.elasticsearch.search.query.IndicesBoostParseElement;
import org.elasticsearch.search.query.QueryBinaryParseElement;
import org.elasticsearch.search.query.QueryParseElement;
import org.elasticsearch.search.query.QueryParserNameParseElement;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.SizeParseElement;
import org.elasticsearch.search.sort.SortParseElement;
import org.elasticsearch.search.sort.TrackScoresParseElement;

public class QueryPhase
implements SearchPhase {
    private final FacetPhase facetPhase;

    @Inject
    public QueryPhase(FacetPhase facetPhase) {
        this.facetPhase = facetPhase;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, FromParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("from", new FromParseElement()).put("size", (FromParseElement)((Object)new SizeParseElement())).put("query_parser_name", (FromParseElement)((Object)new QueryParserNameParseElement())).put("queryParserName", (FromParseElement)((Object)new QueryParserNameParseElement())).put("indices_boost", (FromParseElement)((Object)new IndicesBoostParseElement())).put("indicesBoost", (FromParseElement)((Object)new IndicesBoostParseElement())).put("query", (FromParseElement)((Object)new QueryParseElement())).put("queryBinary", (FromParseElement)((Object)new QueryBinaryParseElement())).put("query_binary", (FromParseElement)((Object)new QueryBinaryParseElement())).put("filter", (FromParseElement)((Object)new FilterParseElement())).put("filterBinary", (FromParseElement)((Object)new FilterBinaryParseElement())).put("filter_binary", (FromParseElement)((Object)new FilterBinaryParseElement())).put("sort", (FromParseElement)((Object)new SortParseElement())).put("trackScores", (FromParseElement)((Object)new TrackScoresParseElement())).put("track_scores", (FromParseElement)((Object)new TrackScoresParseElement())).putAll(this.facetPhase.parseElements());
        return parseElements.build();
    }

    @Override
    public void preProcess(SearchContext context) {
        if (context.query() == null) {
            throw new SearchParseException(context, "No query specified in search request");
        }
        if (context.queryBoost() != 1.0f) {
            context.parsedQuery(new ParsedQuery(new FunctionScoreQuery(context.query(), new BoostScoreFunction(context.queryBoost())), context.parsedQuery()));
        }
        this.facetPhase.preProcess(context);
    }

    @Override
    public void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        if (searchContext.parsedQuery().scopePhases().length > 0) {
            try {
                searchContext.idCache().refresh(searchContext.searcher().subReaders());
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(searchContext, "Failed to refresh id cache for child queries", (Throwable)e);
            }
            block11: for (int i = searchContext.parsedQuery().scopePhases().length - 1; i >= 0; --i) {
                ScopePhase scopePhase = searchContext.parsedQuery().scopePhases()[i];
                if (scopePhase instanceof ScopePhase.TopDocsPhase) {
                    ScopePhase.TopDocsPhase topDocsPhase = (ScopePhase.TopDocsPhase)scopePhase;
                    topDocsPhase.clear();
                    int numDocs = searchContext.from() + searchContext.size();
                    if (numDocs == 0) {
                        numDocs = 1;
                    }
                    try {
                        numDocs *= topDocsPhase.factor();
                        while (true) {
                            if (topDocsPhase.scope() != null) {
                                searchContext.searcher().processingScope(topDocsPhase.scope());
                            }
                            TopDocs topDocs = searchContext.searcher().search(topDocsPhase.query(), numDocs);
                            if (topDocsPhase.scope() != null) {
                                searchContext.searcher().processedScope();
                            }
                            topDocsPhase.processResults(topDocs, searchContext);
                            if (topDocsPhase.numHits() >= searchContext.from() + searchContext.size() || topDocs.totalHits <= numDocs) continue block11;
                            if ((numDocs *= topDocsPhase.incrementalFactor()) <= topDocs.totalHits) continue;
                            numDocs = topDocs.totalHits;
                        }
                    }
                    catch (Exception e) {
                        throw new QueryPhaseExecutionException(searchContext, "Failed to execute child query [" + scopePhase.query() + "]", (Throwable)e);
                    }
                }
                if (!(scopePhase instanceof ScopePhase.CollectorPhase)) continue;
                try {
                    ScopePhase.CollectorPhase collectorPhase = (ScopePhase.CollectorPhase)scopePhase;
                    if (!collectorPhase.requiresProcessing()) continue;
                    if (scopePhase.scope() != null) {
                        searchContext.searcher().processingScope(scopePhase.scope());
                    }
                    Collector collector = collectorPhase.collector();
                    searchContext.searcher().search(collectorPhase.query(), collector);
                    collectorPhase.processCollector(collector);
                    if (collectorPhase.scope() == null) continue;
                    searchContext.searcher().processedScope();
                    continue;
                }
                catch (Exception e) {
                    throw new QueryPhaseExecutionException(searchContext, "Failed to execute child query [" + scopePhase.query() + "]", (Throwable)e);
                }
            }
        }
        searchContext.searcher().processingScope("_main_");
        try {
            int numDocs;
            searchContext.queryResult().from(searchContext.from());
            searchContext.queryResult().size(searchContext.size());
            Query query = searchContext.query();
            if (searchContext.types().length > 0) {
                query = new FilteredQuery(query, searchContext.filterCache().cache(searchContext.mapperService().typesFilter(searchContext.types())));
            }
            if ((numDocs = searchContext.from() + searchContext.size()) == 0) {
                numDocs = 1;
            }
            boolean sort = false;
            if (searchContext.sort() != null) {
                SortField sortField;
                sort = searchContext.sort().getSort().length > 1 ? true : (sortField = searchContext.sort().getSort()[0]).getType() != 0 || sortField.getReverse();
            }
            Object topDocs = sort ? searchContext.searcher().search(query, null, numDocs, searchContext.sort()) : searchContext.searcher().search(query, numDocs);
            searchContext.queryResult().topDocs((TopDocs)topDocs);
        }
        catch (Exception e) {
            throw new QueryPhaseExecutionException(searchContext, "Failed to execute main query", (Throwable)e);
        }
        finally {
            searchContext.searcher().processedScope();
        }
        this.facetPhase.execute(searchContext);
    }
}

