/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.DynamicExecutors;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.MoreExecutors;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;

public class ThreadPool
extends AbstractComponent {
    private final ImmutableMap<String, Executor> executors;
    private final ScheduledExecutorService scheduler;

    public ThreadPool() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    @Inject
    public ThreadPool(Settings settings) {
        super(settings);
        Map<String, Settings> groupSettings = settings.getGroups("threadpool");
        HashMap<String, Executor> executors = Maps.newHashMap();
        executors.put("cached", this.build("cached", "cached", groupSettings.get("cached"), ImmutableSettings.settingsBuilder().put("keep_alive", "30s").build()));
        executors.put("index", this.build("index", "cached", groupSettings.get("index"), ImmutableSettings.Builder.EMPTY_SETTINGS));
        executors.put("search", this.build("search", "cached", groupSettings.get("search"), ImmutableSettings.Builder.EMPTY_SETTINGS));
        executors.put("percolate", this.build("percolate", "cached", groupSettings.get("percolate"), ImmutableSettings.Builder.EMPTY_SETTINGS));
        executors.put("management", this.build("management", "scaling", groupSettings.get("management"), ImmutableSettings.settingsBuilder().put("keep_alive", "30s").put("size", 20).build()));
        executors.put("merge", this.build("merge", "scaling", groupSettings.get("merge"), ImmutableSettings.settingsBuilder().put("keep_alive", "30s").put("size", 20).build()));
        executors.put("snapshot", this.build("snapshot", "scaling", groupSettings.get("snapshot"), ImmutableSettings.Builder.EMPTY_SETTINGS));
        executors.put("same", MoreExecutors.sameThreadExecutor());
        this.executors = ImmutableMap.copyOf(executors);
        this.scheduler = Executors.newScheduledThreadPool(1, EsExecutors.daemonThreadFactory(settings, "[scheduler]"));
    }

    public Executor cached() {
        return this.executor("cached");
    }

    public Executor executor(String name) {
        Executor executor = this.executors.get(name);
        if (executor == null) {
            throw new ElasticSearchIllegalArgumentException("No executor found for [" + name + "]");
        }
        return executor;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, TimeValue interval) {
        return this.scheduler.scheduleWithFixedDelay(new LoggingRunnable(command), interval.millis(), interval.millis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(TimeValue delay, String name, Runnable command) {
        if (!"same".equals(name)) {
            command = new ThreadedRunnable(command, this.executor(name));
        }
        return this.scheduler.schedule(command, delay.millis(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.scheduler.shutdown();
        for (Executor executor : this.executors.values()) {
            if (!(executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor).shutdown();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.scheduler.awaitTermination(timeout, unit);
        for (Executor executor : this.executors.values()) {
            if (!(executor instanceof ThreadPoolExecutor)) continue;
            result &= ((ThreadPoolExecutor)executor).awaitTermination(timeout, unit);
        }
        return result;
    }

    public void shutdownNow() {
        this.scheduler.shutdownNow();
        for (Executor executor : this.executors.values()) {
            if (!(executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor).shutdownNow();
        }
    }

    private Executor build(String name, String defaultType, @Nullable Settings settings, Settings defaultSettings) {
        if (settings == null) {
            settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        }
        String type = settings.get("type", defaultType);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(settings, "[" + name + "]");
        if ("same".equals(type)) {
            this.logger.debug("creating thread_pool [{}], type [{}]", name, type);
            return MoreExecutors.sameThreadExecutor();
        }
        if ("cached".equals(type)) {
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L)));
            this.logger.debug("creating thread_pool [{}], type [{}], keep_alive [{}]", name, type, keepAlive);
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, keepAlive.millis(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        }
        if ("fixed".equals(type)) {
            int size = settings.getAsInt("size", defaultSettings.getAsInt("size", Runtime.getRuntime().availableProcessors() * 5));
            this.logger.debug("creating thread_pool [{}], type [{}], size [{}]", name, type, size);
            return new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new LinkedTransferQueue<Runnable>(), threadFactory);
        }
        if ("scaling".equals(type)) {
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L)));
            int min = settings.getAsInt("min", defaultSettings.getAsInt("min", 1));
            int size = settings.getAsInt("size", defaultSettings.getAsInt("size", Runtime.getRuntime().availableProcessors() * 5));
            this.logger.debug("creating thread_pool [{}], type [{}], min [{}], size [{}], keep_alive [{}]", name, type, min, size, keepAlive);
            return DynamicExecutors.newScalingThreadPool(min, size, keepAlive.millis(), threadFactory);
        }
        if ("blocking".equals(type)) {
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L)));
            int min = settings.getAsInt("min", defaultSettings.getAsInt("min", 1));
            int size = settings.getAsInt("size", defaultSettings.getAsInt("size", Runtime.getRuntime().availableProcessors() * 5));
            SizeValue capacity = settings.getAsSize("capacity", defaultSettings.getAsSize("capacity", new SizeValue(0L)));
            TimeValue waitTime = settings.getAsTime("wait_time", defaultSettings.getAsTime("wait_time", TimeValue.timeValueSeconds(60L)));
            this.logger.debug("creating thread_pool [{}], type [{}], min [{}], size [{}], keep_alive [{}], wait_time [{}]", name, type, min, size, keepAlive, waitTime);
            return DynamicExecutors.newBlockingThreadPool(min, size, keepAlive.millis(), (int)capacity.singles(), waitTime.millis(), threadFactory);
        }
        throw new ElasticSearchIllegalArgumentException("No type found [" + type + "], for [" + name + "]");
    }

    class ThreadedRunnable
    implements Runnable {
        private final Runnable runnable;
        private final Executor executor;

        ThreadedRunnable(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        @Override
        public void run() {
            this.executor.execute(this.runnable);
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }

    class LoggingRunnable
    implements Runnable {
        private final Runnable runnable;

        LoggingRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                ThreadPool.this.logger.warn("failed to run {}", e, this.runnable.toString());
            }
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }

    public static class Names {
        public static final String SAME = "same";
        public static final String CACHED = "cached";
        public static final String INDEX = "index";
        public static final String SEARCH = "search";
        public static final String PERCOLATE = "percolate";
        public static final String MANAGEMENT = "management";
        public static final String MERGE = "merge";
        public static final String SNAPSHOT = "snapshot";
    }
}

