/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class DeletionAwareConstantScoreQuery
extends Query {
    protected final Filter filter;

    public DeletionAwareConstantScoreQuery(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void extractTerms(Set<Term> terms) {
    }

    public Weight createWeight(Searcher searcher) {
        return new ConstantWeight(searcher);
    }

    public String toString(String field) {
        return "ConstantScore(" + this.filter.toString() + ((double)this.getBoost() == 1.0 ? ")" : "^" + this.getBoost());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeletionAwareConstantScoreQuery)) {
            return false;
        }
        DeletionAwareConstantScoreQuery other = (DeletionAwareConstantScoreQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.filter.equals(other.filter);
    }

    public int hashCode() {
        return this.filter.hashCode() + Float.floatToIntBits(this.getBoost());
    }

    protected class ConstantScorer
    extends Scorer {
        final IndexReader reader;
        final DocIdSetIterator _innerIter;
        final float theScore;
        private int doc;

        public ConstantScorer(Similarity similarity, IndexReader reader, Weight w) throws IOException {
            DocIdSetIterator iter;
            super(similarity);
            this.doc = -1;
            this.reader = reader;
            this.theScore = w.getValue();
            DocIdSet docIdSet = DeletionAwareConstantScoreQuery.this.filter.getDocIdSet(reader);
            this._innerIter = docIdSet == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : ((iter = docIdSet.iterator()) == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : iter);
        }

        public int nextDoc() throws IOException {
            while ((this.doc = this._innerIter.nextDoc()) != Integer.MAX_VALUE) {
                if (this.reader.isDeleted(this.doc)) continue;
                return this.doc;
            }
            return this.doc;
        }

        public int docID() {
            return this.doc;
        }

        public float score() throws IOException {
            return this.theScore;
        }

        public int advance(int target) throws IOException {
            this.doc = this._innerIter.advance(target);
            if (this.doc != Integer.MAX_VALUE) {
                if (!this.reader.isDeleted(this.doc)) {
                    return this.doc;
                }
                while ((this.doc = this._innerIter.nextDoc()) != Integer.MAX_VALUE) {
                    if (this.reader.isDeleted(this.doc)) continue;
                    return this.doc;
                }
                return this.doc;
            }
            return this.doc;
        }
    }

    protected class ConstantWeight
    extends Weight {
        private Similarity similarity;
        private float queryNorm;
        private float queryWeight;

        public ConstantWeight(Searcher searcher) {
            this.similarity = DeletionAwareConstantScoreQuery.this.getSimilarity(searcher);
        }

        public Query getQuery() {
            return DeletionAwareConstantScoreQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = DeletionAwareConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new ConstantScorer(this.similarity, reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            ConstantScorer cs = new ConstantScorer(this.similarity, reader, this);
            boolean exists = cs._innerIter.advance(doc) == doc;
            ComplexExplanation result = new ComplexExplanation();
            if (exists) {
                result.setDescription("ConstantScoreQuery(" + DeletionAwareConstantScoreQuery.this.filter + "), product of:");
                result.setValue(this.queryWeight);
                result.setMatch(Boolean.TRUE);
                result.addDetail(new Explanation(DeletionAwareConstantScoreQuery.this.getBoost(), "boost"));
                result.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            } else {
                result.setDescription("ConstantScoreQuery(" + DeletionAwareConstantScoreQuery.this.filter + ") doesn't match id " + doc);
                result.setValue(0.0f);
                result.setMatch(Boolean.FALSE);
            }
            return result;
        }
    }
}

