/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class PutIndexTemplateRequest
extends MasterNodeOperationRequest {
    private String name;
    private String cause = "";
    private String template;
    private int order;
    private boolean create;
    private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
    private Map<String, String> mappings = Maps.newHashMap();
    private TimeValue timeout = new TimeValue(10L, TimeUnit.SECONDS);

    PutIndexTemplateRequest() {
    }

    public PutIndexTemplateRequest(String name) {
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = Actions.addValidationError("name is missing", validationException);
        }
        if (this.template == null) {
            validationException = Actions.addValidationError("template is missing", validationException);
        }
        return validationException;
    }

    public PutIndexTemplateRequest name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutIndexTemplateRequest template(String template) {
        this.template = template;
        return this;
    }

    public String template() {
        return this.template;
    }

    public PutIndexTemplateRequest order(int order) {
        this.order = order;
        return this;
    }

    public int order() {
        return this.order;
    }

    public PutIndexTemplateRequest create(boolean create) {
        this.create = create;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public PutIndexTemplateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutIndexTemplateRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutIndexTemplateRequest settings(String source) {
        this.settings = ImmutableSettings.settingsBuilder().loadFromSource(source).build();
        return this;
    }

    public PutIndexTemplateRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    Settings settings() {
        return this.settings;
    }

    public PutIndexTemplateRequest mapping(String type, String source) {
        this.mappings.put(type, source);
        return this;
    }

    public PutIndexTemplateRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public PutIndexTemplateRequest mapping(String type, XContentBuilder source) {
        try {
            this.mappings.put(type, source.string());
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to build json for mapping request", e);
        }
        return this;
    }

    public PutIndexTemplateRequest mapping(String type, Map<String, Object> source) {
        if (source.size() != 1 || !source.containsKey(type)) {
            source = MapBuilder.newMapBuilder().put(type, source).map();
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            return this.mapping(type, builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    Map<String, String> mappings() {
        return this.mappings;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public PutIndexTemplateRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public PutIndexTemplateRequest timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.cause = in.readUTF();
        this.name = in.readUTF();
        this.template = in.readUTF();
        this.order = in.readInt();
        this.create = in.readBoolean();
        this.settings = ImmutableSettings.readSettingsFromStream(in);
        this.timeout = TimeValue.readTimeValue(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.mappings.put(in.readUTF(), in.readUTF());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeUTF(this.cause);
        out.writeUTF(this.name);
        out.writeUTF(this.template);
        out.writeInt(this.order);
        out.writeBoolean(this.create);
        ImmutableSettings.writeSettingsToStream(this.settings, out);
        this.timeout.writeTo(out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
    }
}

