/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.count.ShardCountRequest;
import org.elasticsearch.action.count.ShardCountResponse;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportCountAction
extends TransportBroadcastOperationAction<CountRequest, CountResponse, ShardCountRequest, ShardCountResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportCountAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
    }

    @Override
    protected String executor() {
        return "search";
    }

    @Override
    protected String transportAction() {
        return "indices/count";
    }

    @Override
    protected String transportShardAction() {
        return "indices/count/shard";
    }

    @Override
    protected CountRequest newRequest() {
        return new CountRequest();
    }

    @Override
    protected ShardCountRequest newShardRequest() {
        return new ShardCountRequest();
    }

    @Override
    protected ShardCountRequest newShardRequest(ShardRouting shard, CountRequest request) {
        return new ShardCountRequest(shard.index(), shard.id(), request);
    }

    @Override
    protected ShardCountResponse newShardResponse() {
        return new ShardCountResponse();
    }

    @Override
    protected GroupShardsIterator shards(CountRequest request, ClusterState clusterState) {
        return this.clusterService.operationRouting().searchShards(clusterState, request.indices(), request.queryHint(), request.routing());
    }

    @Override
    protected void checkBlock(CountRequest request, ClusterState state) {
        for (String index : request.indices()) {
            state.blocks().indexBlocked(ClusterBlockLevel.READ, index);
        }
    }

    @Override
    protected CountResponse newResponse(CountRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        long count = 0L;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) {
                ++failedShards;
                continue;
            }
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = Lists.newArrayList();
                }
                shardFailures.add(new DefaultShardOperationFailedException((BroadcastShardOperationFailedException)shardResponse));
                continue;
            }
            count += ((ShardCountResponse)shardResponse).count();
            ++successfulShards;
        }
        return new CountResponse(count, shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ShardCountResponse shardOperation(ShardCountRequest request) throws ElasticSearchException {
        IndexShard indexShard = this.indicesService.indexServiceSafe(request.index()).shardSafe(request.shardId());
        long count = indexShard.count(request.minScore(), request.querySource(), request.querySourceOffset(), request.querySourceLength(), request.queryParserName(), request.types());
        return new ShardCountResponse(request.index(), request.shardId(), count);
    }
}

